/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.common;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.nexusrpc.Link;
import io.temporal.api.failure.v1.Failure;
import io.temporal.common.converter.DataConverter;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;

public class NexusUtil {
    private static final JsonFormat.Printer JSON_PRINTER = JsonFormat.printer().omittingInsignificantWhitespace();
    private static final String TEMPORAL_FAILURE_TYPE_STRING = Failure.getDescriptor().getFullName();
    private static final Map<String, String> NEXUS_FAILURE_METADATA = Collections.singletonMap("type", TEMPORAL_FAILURE_TYPE_STRING);

    public static Duration parseRequestTimeout(String timeout) {
        try {
            if (timeout.endsWith("m")) {
                return Duration.ofMillis(Math.round(60000.0 * Double.parseDouble(timeout.substring(0, timeout.length() - 1))));
            }
            if (timeout.endsWith("ms")) {
                return Duration.ofMillis(Math.round(Double.parseDouble(timeout.substring(0, timeout.length() - 2))));
            }
            if (timeout.endsWith("s")) {
                return Duration.ofMillis(Math.round(1000.0 * Double.parseDouble(timeout.substring(0, timeout.length() - 1))));
            }
            throw new IllegalArgumentException("Invalid timeout format: " + timeout);
        }
        catch (NullPointerException | NumberFormatException e) {
            throw new IllegalArgumentException("Invalid timeout format: " + timeout);
        }
    }

    public static Link nexusProtoLinkToLink(io.temporal.api.nexus.v1.Link nexusLink) throws URISyntaxException {
        return Link.newBuilder().setType(nexusLink.getType()).setUri(new URI(nexusLink.getUrl())).build();
    }

    public static io.temporal.api.nexus.v1.Failure exceptionToNexusFailure(Throwable exception, DataConverter dataConverter) {
        String details;
        Failure failure = dataConverter.exceptionToFailure(exception);
        try {
            details = JSON_PRINTER.print((MessageOrBuilder)failure.toBuilder().setMessage("").build());
        }
        catch (InvalidProtocolBufferException e) {
            return io.temporal.api.nexus.v1.Failure.newBuilder().setMessage("Failed to serialize failure details").setDetails(ByteString.copyFromUtf8((String)e.getMessage())).build();
        }
        return io.temporal.api.nexus.v1.Failure.newBuilder().setMessage(failure.getMessage()).setDetails(ByteString.copyFromUtf8((String)details)).putAllMetadata(NEXUS_FAILURE_METADATA).build();
    }

    private NexusUtil() {
    }
}

