/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.plugin;

import io.takari.incrementalbuild.Output;
import io.takari.incrementalbuild.aggregator.AggregatorBuildContext;
import io.takari.incrementalbuild.aggregator.InputAggregator;
import io.takari.incrementalbuild.aggregator.InputSet;
import io.takari.maven.plugins.TakariLifecycleMojo;
import io.takari.maven.plugins.plugin.LegacyPluginDescriptors;
import io.takari.maven.plugins.plugin.PluginDescriptorWriter;
import io.takari.maven.plugins.plugin.Sorting;
import io.takari.maven.plugins.plugin.model.MojoDescriptor;
import io.takari.maven.plugins.plugin.model.MojoParameter;
import io.takari.maven.plugins.plugin.model.MojoRequirement;
import io.takari.maven.plugins.plugin.model.PluginDescriptor;
import io.takari.maven.plugins.plugin.model.io.xpp3.PluginDescriptorXpp3Reader;
import io.takari.maven.plugins.plugin.model.io.xpp3.PluginDescriptorXpp3Writer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="plugin-descriptor", defaultPhase=LifecyclePhase.PROCESS_CLASSES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class PluginDescriptorMojo
extends TakariLifecycleMojo {
    private static final String PATH_MOJOS_XML = "META-INF/takari/mojos.xml";
    private static final String PATH_PLUGIN_XML = "META-INF/maven/plugin.xml";
    @Parameter(defaultValue="${project.groupId}", readonly=true)
    private String groupId;
    @Parameter(defaultValue="${project.artifactId}", readonly=true)
    private String artifactId;
    @Parameter(defaultValue="${project.version}", readonly=true)
    private String version;
    @Parameter(defaultValue="${project.name}", readonly=true)
    private String name;
    @Parameter(defaultValue="${project.description}", readonly=true)
    private String description;
    @Parameter
    private String goalPrefix;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.compileArtifacts}", readonly=true)
    private List<Artifact> dependencies;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/annotations")
    private File generatedSourcesDirectory;
    @Component
    private AggregatorBuildContext context;

    @Override
    protected void executeMojo() throws MojoExecutionException {
        try {
            InputSet inputSet = this.context.newInputSet();
            final LinkedHashSet<File> classpathJars = new LinkedHashSet<File>();
            final LinkedHashSet<File> classpathFiles = new LinkedHashSet<File>();
            for (Artifact artifact : this.dependencies) {
                File file;
                if (artifact.getFile().isFile()) {
                    classpathJars.add(inputSet.addInput(artifact.getFile()));
                    continue;
                }
                if (!artifact.getFile().isDirectory() || !(file = new File(artifact.getFile(), PATH_MOJOS_XML)).canRead()) continue;
                classpathFiles.add(inputSet.addInput(file));
            }
            final Iterable files = inputSet.addInputs(this.generatedSourcesDirectory, Collections.singleton("*.mojo.xml"), null);
            inputSet.aggregateIfNecessary(new File(this.outputDirectory, PATH_PLUGIN_XML), new InputAggregator(){

                public void aggregate(Output<File> output, Iterable<File> inputs) throws IOException {
                    PluginDescriptorMojo.this.createPluginXml(output, files, classpathFiles, classpathJars);
                }
            });
            inputSet.aggregateIfNecessary(new File(this.outputDirectory, PATH_MOJOS_XML), new InputAggregator(){

                public void aggregate(Output<File> output, Iterable<File> inputs) throws IOException {
                    PluginDescriptorMojo.this.createMojosXml(output, files);
                }
            });
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create plugin descriptor", (Exception)e);
        }
    }

    protected void createMojosXml(Output<File> output, Iterable<File> files) throws IOException {
        PluginDescriptor mojos = new PluginDescriptor();
        ArrayList<MojoDescriptor> descriptors = new ArrayList<MojoDescriptor>(this.loadMojos(files).values());
        Sorting.sortDescriptors(descriptors);
        for (MojoDescriptor descriptor : descriptors) {
            mojos.addMojo(descriptor);
        }
        Throwable throwable = null;
        Iterator iterator = null;
        try (OutputStream out = output.newOutputStream();){
            new PluginDescriptorXpp3Writer().write(out, mojos);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void createPluginXml(Output<File> output, Iterable<File> inputs, Set<File> classpathFiles, Set<File> classpathJars) throws IOException {
        Map<String, MojoDescriptor> classpathMojos = this.loadClasspathMojos(classpathFiles, classpathJars);
        Map<String, MojoDescriptor> mojos = this.loadMojos(inputs);
        PluginDescriptor plugin = this.newPluginDescriptor();
        for (MojoDescriptor gleaned : mojos.values()) {
            MojoDescriptor descriptor = gleaned.clone();
            if (descriptor.getGoal() == null) continue;
            for (String parent : descriptor.getSuperclasses()) {
                MojoDescriptor inherited = mojos.get(parent);
                if (inherited == null) {
                    inherited = classpathMojos.get(parent);
                }
                if (inherited == null) continue;
                for (MojoParameter parameter : inherited.getParameters()) {
                    if (this.containsField(descriptor, parameter.getName())) continue;
                    descriptor.addParameter(parameter.clone());
                }
                for (MojoRequirement requirement : inherited.getRequirements()) {
                    if (this.containsField(descriptor, requirement.getFieldName())) continue;
                    descriptor.addRequirement(requirement.clone());
                }
            }
            plugin.addMojo(descriptor);
        }
        Throwable throwable = null;
        Iterator<MojoDescriptor> iterator = null;
        try (OutputStream out = output.newOutputStream();){
            new PluginDescriptorWriter().writeDescriptor(out, plugin);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private boolean containsField(MojoDescriptor descriptor, String fieldName) {
        for (MojoParameter parameter : descriptor.getParameters()) {
            if (!fieldName.equals(parameter.getName())) continue;
            return true;
        }
        for (MojoRequirement requirement : descriptor.getRequirements()) {
            if (!fieldName.equals(requirement.getFieldName())) continue;
            return true;
        }
        return false;
    }

    private Map<String, MojoDescriptor> loadMojos(Iterable<File> inputs) throws IOException {
        HashMap<String, MojoDescriptor> mojos = new HashMap<String, MojoDescriptor>();
        for (File mojoXml : inputs) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (FileInputStream is = new FileInputStream(mojoXml);){
                    this.readMojosXml(mojos, is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (XmlPullParserException e) {
                throw new IOException(e);
            }
        }
        return mojos;
    }

    /*
     * Unable to fully structure code
     */
    private Map<String, MojoDescriptor> loadClasspathMojos(Set<File> files, Set<File> jars) {
        mojos = new HashMap<String, MojoDescriptor>();
        for (File jarFile : jars) {
            try {
                var6_6 = null;
                var7_11 = null;
                try {
                    block44: {
                        zip = new ZipFile(jarFile);
                        try {
                            entry = zip.getEntry("META-INF/takari/mojos.xml");
                            if (entry == null) ** GOTO lbl38
                            var10_16 = null;
                            var11_19 = null;
                            try {
                                is = zip.getInputStream(entry);
                                try {
                                    this.readMojosXml(mojos, is);
                                }
                                finally {
                                    if (is != null) {
                                        is.close();
                                    }
                                }
                            }
                            catch (Throwable var11_20) {
                                if (var10_16 == null) {
                                    var10_16 = var11_20;
                                } else if (var10_16 != var11_20) {
                                    var10_16.addSuppressed(var11_20);
                                }
                                throw var10_16;
                            }
                            if (zip == null) continue;
                        }
                        catch (Throwable var6_7) {
                            if (zip != null) {
                                zip.close();
                            }
                            throw var6_7;
                        }
                        zip.close();
                        continue;
lbl38:
                        // 1 sources

                        entry = zip.getEntry("META-INF/maven/plugin.xml");
                        if (entry == null) break block44;
                        var10_16 = null;
                        var11_19 = null;
                        try {
                            is = zip.getInputStream(entry);
                            try {
                                this.readPluginXml(mojos, is);
                            }
                            finally {
                                if (is != null) {
                                    is.close();
                                }
                            }
                        }
                        catch (Throwable var11_21) {
                            if (var10_16 == null) {
                                var10_16 = var11_21;
                            } else if (var10_16 != var11_21) {
                                var10_16.addSuppressed(var11_21);
                            }
                            throw var10_16;
                        }
                        if (zip == null) continue;
                        zip.close();
                        continue;
                    }
                    if (zip == null) continue;
                    zip.close();
                }
                catch (Throwable var7_12) {
                    if (var6_6 == null) {
                        var6_6 = var7_12;
                    } else if (var6_6 != var7_12) {
                        var6_6.addSuppressed(var7_12);
                    }
                    throw var6_6;
                }
            }
            catch (IOException | XmlPullParserException e) {
                this.logger.warn("Could not read dependency mojos.xml " + jarFile, e);
            }
        }
        for (File mojosXmlFile : files) {
            try {
                e = null;
                var7_11 = null;
                try {
                    is = new FileInputStream(mojosXmlFile);
                    try {
                        this.readMojosXml(mojos, is);
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                catch (Throwable var7_13) {
                    if (e == null) {
                        e = var7_13;
                    } else if (e != var7_13) {
                        e.addSuppressed(var7_13);
                    }
                    throw e;
                }
            }
            catch (IOException | XmlPullParserException e) {
                this.logger.warn("Could not read dependency mojos.xml " + mojosXmlFile, e);
            }
        }
        return mojos;
    }

    private void readMojosXml(Map<String, MojoDescriptor> mojos, InputStream is) throws XmlPullParserException, IOException {
        PluginDescriptor pluginDescriptor = new PluginDescriptorXpp3Reader().read(is);
        for (MojoDescriptor mojo : pluginDescriptor.getMojos()) {
            mojos.put(mojo.getImplementation(), mojo);
        }
    }

    private void readPluginXml(Map<String, MojoDescriptor> mojos, InputStream is) throws XmlPullParserException, IOException {
        for (MojoDescriptor mojo : LegacyPluginDescriptors.readMojos(is)) {
            mojos.put(mojo.getImplementation(), mojo);
        }
    }

    private PluginDescriptor newPluginDescriptor() {
        String defaultGoalPrefix = org.apache.maven.plugin.descriptor.PluginDescriptor.getGoalPrefixFromArtifactId((String)this.artifactId);
        if (this.goalPrefix == null) {
            this.goalPrefix = defaultGoalPrefix;
        } else if (!this.goalPrefix.equals(defaultGoalPrefix)) {
            this.getLog().warn((CharSequence)("\n\nGoal prefix is specified as: '" + this.goalPrefix + "'. " + "Maven currently expects it to be '" + defaultGoalPrefix + "'.\n"));
        }
        PluginDescriptor pluginDescriptor = new PluginDescriptor();
        pluginDescriptor.setGroupId(this.groupId);
        pluginDescriptor.setArtifactId(this.artifactId);
        pluginDescriptor.setVersion(this.version);
        pluginDescriptor.setGoalPrefix(this.goalPrefix);
        pluginDescriptor.setName(this.name);
        pluginDescriptor.setDescription(this.description);
        pluginDescriptor.setInheritedByDefault(true);
        return pluginDescriptor;
    }
}

