/*
 * Decompiled with CFR 0.152.
 */
package io.takari.incrementalbuild.spi;

import io.takari.incrementalbuild.BuildContext;
import io.takari.incrementalbuild.spi.DefaultBuildContextState;
import io.takari.incrementalbuild.spi.DefaultInput;
import io.takari.incrementalbuild.spi.DefaultInputMetadata;
import io.takari.incrementalbuild.spi.DefaultOutput;
import io.takari.incrementalbuild.spi.DefaultOutputMetadata;
import io.takari.incrementalbuild.spi.FileMatcher;
import io.takari.incrementalbuild.spi.FileState;
import io.takari.incrementalbuild.spi.Message;
import io.takari.incrementalbuild.spi.QualifiedName;
import io.takari.incrementalbuild.spi.ResourceHolder;
import io.takari.incrementalbuild.workspace.MessageSink;
import io.takari.incrementalbuild.workspace.Workspace;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultBuildContext<BuildFailureException extends Exception>
implements BuildContext {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final File stateFile;
    private final DefaultBuildContextState state;
    private final DefaultBuildContextState oldState;
    private final boolean escalated;
    private final Map<Object, DefaultInput<?>> processedInputs = new HashMap();
    private final Set<File> uptodateOutputs = new HashSet<File>();
    private final Map<File, DefaultOutput> processedOutputs = new HashMap<File, DefaultOutput>();
    private final Set<File> deletedInputs = new HashSet<File>();
    private final Set<File> deletedOutputs = new HashSet<File>();
    private final Workspace workspace;
    private final MessageSink messageSink;

    public DefaultBuildContext(Workspace workspace, MessageSink messageSink, File stateFile, Map<String, Serializable> configuration) {
        if (workspace == null) {
            throw new NullPointerException();
        }
        if (configuration == null) {
            throw new NullPointerException();
        }
        this.stateFile = stateFile;
        this.state = DefaultBuildContextState.withConfiguration(configuration);
        this.oldState = DefaultBuildContextState.loadFrom(stateFile);
        this.messageSink = messageSink;
        boolean configurationChanged = this.getConfigurationChanged();
        if (workspace.getMode() == Workspace.Mode.ESCALATED) {
            this.escalated = true;
            this.workspace = workspace;
        } else if (workspace.getMode() == Workspace.Mode.SUPPRESSED) {
            this.escalated = false;
            this.workspace = workspace;
        } else if (configurationChanged) {
            this.escalated = true;
            this.workspace = workspace.escalate();
        } else {
            this.escalated = false;
            this.workspace = workspace;
        }
        if (this.escalated && stateFile != null) {
            if (!stateFile.canRead()) {
                this.log.info("Previous incremental build state does not exist, performing full build");
            } else {
                this.log.info("Incremental build configuration change detected, performing full build");
            }
        } else {
            this.log.info("Performing incremental build");
        }
    }

    private boolean getConfigurationChanged() {
        Map<String, Serializable> configuration = this.state.configuration;
        Map<String, Serializable> oldConfiguration = this.oldState.configuration;
        if (oldConfiguration.isEmpty()) {
            return true;
        }
        TreeSet<String> keys = new TreeSet<String>();
        keys.addAll(configuration.keySet());
        keys.addAll(oldConfiguration.keySet());
        boolean result = false;
        StringBuilder msg = new StringBuilder();
        for (String key : keys) {
            Serializable value = configuration.get(key);
            Serializable oldValue = oldConfiguration.get(key);
            if (DefaultBuildContext.equals(oldValue, value)) continue;
            result = true;
            msg.append("\n   ");
            if (value == null) {
                msg.append("REMOVED");
            } else if (oldValue == null) {
                msg.append("ADDED");
            } else {
                msg.append("CHANGED");
            }
            msg.append(' ').append(key);
        }
        if (result) {
            this.log.debug("Incremental build configuration key changes:{}", (Object)msg.toString());
        }
        return result;
    }

    private static boolean equals(Serializable a, Serializable b) {
        return a != null ? a.equals(b) : b == null;
    }

    public boolean isEscalated() {
        return this.escalated;
    }

    public <T> DefaultInput<T> processInput(DefaultInputMetadata<T> inputMetadata) {
        if (inputMetadata.context != this) {
            throw new IllegalArgumentException();
        }
        if (inputMetadata instanceof DefaultInput) {
            return (DefaultInput)inputMetadata;
        }
        T inputResource = inputMetadata.getResource();
        DefaultInput<Object> input = this.processedInputs.get(inputResource);
        if (input == null) {
            input = new DefaultInput<T>(this, this.state, inputResource);
            this.processedInputs.put(inputResource, input);
            this.clearMessages(inputResource);
        }
        return input;
    }

    public Iterable<DefaultInput<File>> registerAndProcessInputs(File basedir, Collection<String> includes, Collection<String> excludes) throws IOException {
        basedir = this.normalize(basedir);
        final ArrayList<DefaultInput<File>> inputs = new ArrayList<DefaultInput<File>>();
        final FileMatcher matcher = FileMatcher.matcher(basedir, includes, excludes);
        this.workspace.walk(basedir, new Workspace.FileVisitor(){

            public void visit(File file, long lastModified, long length, Workspace.ResourceStatus status) {
                if (matcher.matches(file)) {
                    switch (status) {
                        case MODIFIED: 
                        case NEW: {
                            BuildContext.Input input = DefaultBuildContext.this.getProcessedInput(file);
                            if (input == null) {
                                DefaultInputMetadata metadata = DefaultBuildContext.this.registerNormalizedInput(file, lastModified, length);
                                if (DefaultBuildContext.this.workspace.getMode() == Workspace.Mode.DELTA || DefaultBuildContext.this.getInputStatus(file, true) != BuildContext.ResourceStatus.UNMODIFIED) {
                                    input = metadata.process();
                                }
                            }
                            if (input == null) break;
                            inputs.add(input);
                            break;
                        }
                        case REMOVED: {
                            DefaultBuildContext.this.deletedInputs.add(file);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                }
            }
        });
        return inputs;
    }

    private <I> DefaultInput<I> getProcessedInput(I resource) {
        return this.processedInputs.get(resource);
    }

    public Iterable<DefaultOutputMetadata> deleteStaleOutputs(boolean eager) throws IOException {
        ArrayList<DefaultOutputMetadata> deleted = new ArrayList<DefaultOutputMetadata>();
        block0: for (File outputFile : this.oldState.outputs.keySet()) {
            if (this.processedOutputs.containsKey(outputFile) || this.uptodateOutputs.contains(outputFile)) continue;
            Collection<Object> associatedInputs = this.oldState.outputInputs.get(outputFile);
            if (associatedInputs != null) {
                for (Object inputResource : associatedInputs) {
                    DefaultInput<?> input;
                    if ((!this.isRegistered(inputResource) || this.processedInputs.containsKey(inputResource)) && ((input = this.processedInputs.get(inputResource)) == null || eager && !this.isAssociatedOutput(input, outputFile))) continue;
                    continue block0;
                }
            } else if (!eager) continue;
            if (!this.deletedOutputs.add(outputFile)) continue;
            this.deleteStaleOutput(outputFile);
            deleted.add(new DefaultOutputMetadata(this, this.oldState, outputFile));
        }
        return deleted;
    }

    private boolean isRegistered(Object inputResource) {
        if (this.workspace.getMode() == Workspace.Mode.DELTA || this.workspace.getMode() == Workspace.Mode.SUPPRESSED) {
            return !this.deletedInputs.contains(inputResource);
        }
        return this.state.inputs.containsKey(inputResource);
    }

    protected void deleteStaleOutput(File outputFile) throws IOException {
        this.workspace.deleteFile(outputFile);
    }

    private static <K, V> void put(Map<K, Collection<V>> multimap, K key, V value) {
        Collection<V> values = multimap.get(key);
        if (values == null) {
            values = new LinkedHashSet<V>();
            multimap.put(key, values);
        }
        values.add(value);
    }

    private static <K, V> void putAll(Map<K, Collection<V>> multimap, K key, Collection<V> value) {
        Collection<V> values = multimap.get(key);
        if (values == null) {
            values = new LinkedHashSet<V>();
            multimap.put(key, values);
        }
        values.addAll(value);
    }

    public DefaultOutput processOutput(File outputFile) {
        if (!this.uptodateOutputs.isEmpty()) {
            throw new IllegalStateException();
        }
        DefaultOutput output = this.processedOutputs.get(outputFile = this.normalize(outputFile));
        if (output == null) {
            output = new DefaultOutput(this, this.state, outputFile);
            this.processedOutputs.put(outputFile, output);
            this.workspace.processOutput(outputFile);
            this.clearMessages(output);
        }
        return output;
    }

    public void markOutputsAsUptodate() {
        if (!(this.processedOutputs.isEmpty() && this.deletedOutputs.isEmpty() && this.oldState.inputOutputs.isEmpty())) {
            throw new IllegalStateException();
        }
        this.uptodateOutputs.addAll(this.oldState.outputs.keySet());
    }

    public void markOutputAsUptodate(File outputFile) {
        this.uptodateOutputs.add(outputFile);
    }

    public DefaultInput<File> processIncludedInput(File inputFile) {
        if (this.state.includedInputs.containsKey(inputFile = this.normalize(inputFile))) {
            return new DefaultInput<File>(this, this.state, inputFile);
        }
        File file = this.registerInput(this.state.includedInputs, this.newFileState(inputFile));
        return new DefaultInput<File>(this, this.state, file);
    }

    public BuildContext.ResourceStatus getInputStatus(Object inputResource, boolean associated) {
        if (!this.isRegistered(inputResource)) {
            if (this.oldState.inputs.containsKey(inputResource)) {
                return BuildContext.ResourceStatus.REMOVED;
            }
            throw new IllegalArgumentException("Unregistered input file " + inputResource);
        }
        ResourceHolder<?> oldInputState = this.oldState.inputs.get(inputResource);
        if (oldInputState == null) {
            return BuildContext.ResourceStatus.NEW;
        }
        if (this.escalated) {
            return BuildContext.ResourceStatus.MODIFIED;
        }
        BuildContext.ResourceStatus status = this.getResourceStatus(oldInputState);
        if (status != BuildContext.ResourceStatus.UNMODIFIED) {
            return status;
        }
        if (associated) {
            Collection<File> outputFiles;
            Collection<Object> includedInputs = this.oldState.inputIncludedInputs.get(inputResource);
            if (includedInputs != null) {
                for (Object includedInput : includedInputs) {
                    ResourceHolder<?> includedInputState = this.oldState.includedInputs.get(includedInput);
                    if (this.getResourceStatus(includedInputState) == BuildContext.ResourceStatus.UNMODIFIED) continue;
                    return BuildContext.ResourceStatus.MODIFIED;
                }
            }
            if ((outputFiles = this.oldState.inputOutputs.get(inputResource)) != null) {
                for (File outputFile : outputFiles) {
                    ResourceHolder<File> outputState = this.oldState.outputs.get(outputFile);
                    if (this.getResourceStatus(outputState) == BuildContext.ResourceStatus.UNMODIFIED) continue;
                    return BuildContext.ResourceStatus.MODIFIED;
                }
            }
        }
        return BuildContext.ResourceStatus.UNMODIFIED;
    }

    private BuildContext.ResourceStatus getResourceStatus(ResourceHolder<?> holder) {
        if (holder instanceof FileState) {
            FileState fileState = (FileState)holder;
            switch (this.workspace.getResourceStatus(fileState.file, fileState.lastModified, fileState.length)) {
                case NEW: {
                    return BuildContext.ResourceStatus.NEW;
                }
                case MODIFIED: {
                    return BuildContext.ResourceStatus.MODIFIED;
                }
                case REMOVED: {
                    return BuildContext.ResourceStatus.REMOVED;
                }
                case UNMODIFIED: {
                    return BuildContext.ResourceStatus.UNMODIFIED;
                }
            }
            throw new IllegalArgumentException();
        }
        return holder.getStatus();
    }

    public BuildContext.ResourceStatus getOutputStatus(File outputFile) {
        ResourceHolder<File> oldOutputState = this.oldState.outputs.get(outputFile);
        if (oldOutputState == null) {
            if (this.processedOutputs.containsKey(outputFile)) {
                return BuildContext.ResourceStatus.NEW;
            }
            throw new IllegalArgumentException("Output is not processed " + outputFile);
        }
        BuildContext.ResourceStatus status = this.getResourceStatus(oldOutputState);
        if (this.escalated && status == BuildContext.ResourceStatus.UNMODIFIED) {
            status = BuildContext.ResourceStatus.MODIFIED;
        }
        return status;
    }

    public DefaultInputMetadata<File> registerInput(File inputFile) {
        inputFile = this.normalize(inputFile);
        return this.registerNormalizedInput(inputFile, inputFile.lastModified(), inputFile.length());
    }

    private DefaultInputMetadata<File> registerNormalizedInput(File inputFile, long lastModified, long length) {
        if (this.isRegistered(inputFile)) {
            return new DefaultInputMetadata<File>(this, this.oldState, inputFile);
        }
        return this.registerInput(this.newFileState(inputFile, lastModified, length));
    }

    public <T extends Serializable> DefaultInputMetadata<T> registerInput(ResourceHolder<T> holder) {
        T resource = this.registerInput(this.state.inputs, holder);
        return new DefaultInputMetadata<T>(this, this.oldState, resource);
    }

    private <T extends Serializable> T registerInput(Map<Object, ResourceHolder<?>> inputs, ResourceHolder<T> holder) {
        T resource = holder.getResource();
        ResourceHolder<?> other = inputs.get(resource);
        if (other == null) {
            if (this.getResourceStatus(holder) == BuildContext.ResourceStatus.REMOVED) {
                throw new IllegalArgumentException("Input does not exist " + resource);
            }
            inputs.put(resource, holder);
        } else if (!holder.equals(other)) {
            throw new IllegalArgumentException("Inconsistent input state " + resource);
        }
        return resource;
    }

    public Iterable<DefaultInputMetadata<File>> registerInputs(Iterable<File> inputs) {
        ArrayList<DefaultInputMetadata<File>> result = new ArrayList<DefaultInputMetadata<File>>();
        for (File inputFile : inputs) {
            result.add((DefaultInputMetadata<File>)this.registerInput(inputFile));
        }
        return result;
    }

    public Iterable<DefaultInputMetadata<File>> registerInputs(File basedir, Collection<String> includes, Collection<String> excludes) throws IOException {
        basedir = this.normalize(basedir);
        final ArrayList<DefaultInputMetadata<File>> result = new ArrayList<DefaultInputMetadata<File>>();
        final FileMatcher matcher = FileMatcher.matcher(basedir, includes, excludes);
        this.workspace.walk(basedir, new Workspace.FileVisitor(){

            public void visit(File file, long lastModified, long length, Workspace.ResourceStatus status) {
                if (matcher.matches(file)) {
                    switch (status) {
                        case MODIFIED: 
                        case NEW: {
                            result.add(DefaultBuildContext.this.registerNormalizedInput(file, lastModified, length));
                            break;
                        }
                        case REMOVED: {
                            DefaultBuildContext.this.deletedInputs.add(file);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                }
            }
        });
        if (this.workspace.getMode() == Workspace.Mode.DELTA) {
            FileMatcher absoluteMatcher = FileMatcher.matcher(basedir, includes, excludes);
            for (Object resource : this.oldState.inputs.keySet()) {
                File file;
                if (!(resource instanceof File) || this.state.inputs.containsKey(file = (File)resource) || this.deletedInputs.contains(file) || !absoluteMatcher.matches(file)) continue;
                result.add((DefaultInputMetadata<File>)this.registerInput(file));
            }
        }
        return result;
    }

    public Iterable<DefaultInputMetadata<File>> getRegisteredInputs() {
        return this.getRegisteredInputs(File.class);
    }

    public <T> Iterable<DefaultInputMetadata<T>> getRegisteredInputs(Class<T> clazz) {
        LinkedHashSet<DefaultInputMetadata<T>> result = new LinkedHashSet<DefaultInputMetadata<T>>();
        for (Object inputResource : this.state.inputs.keySet()) {
            if (!clazz.isInstance(inputResource)) continue;
            DefaultInputMetadata input = this.getProcessedInput(clazz.cast(inputResource));
            if (input == null) {
                input = new DefaultInputMetadata<T>(this, this.state, clazz.cast(inputResource));
            }
            result.add(input);
        }
        this.addRemovedInputs(result, clazz);
        return result;
    }

    public <T> Set<DefaultInputMetadata<T>> getRemovedInputs(Class<T> clazz) {
        LinkedHashSet<DefaultInputMetadata<T>> result = new LinkedHashSet<DefaultInputMetadata<T>>();
        this.addRemovedInputs(result, clazz);
        return result;
    }

    private <T> void addRemovedInputs(Set<DefaultInputMetadata<T>> result, Class<T> clazz) {
        for (Object inputResource : this.oldState.inputs.keySet()) {
            if (this.isRegistered(inputResource) || !clazz.isInstance(inputResource)) continue;
            result.add(new DefaultInputMetadata<T>(this, this.oldState, clazz.cast(inputResource)));
        }
    }

    public Iterable<DefaultOutputMetadata> getProcessedOutputs() {
        LinkedHashSet<DefaultOutputMetadata> result = new LinkedHashSet<DefaultOutputMetadata>();
        for (DefaultOutput output : this.processedOutputs.values()) {
            result.add(output);
        }
        block1: for (File outputFile : this.oldState.outputs.keySet()) {
            if (this.processedOutputs.containsKey(outputFile)) continue;
            Collection<Object> associatedInputs = this.oldState.outputInputs.get(outputFile);
            if (associatedInputs != null) {
                for (Object inputResource : associatedInputs) {
                    if (!this.isRegistered(inputResource) || this.processedInputs.containsKey(inputResource)) continue;
                    result.add(new DefaultOutputMetadata(this, this.oldState, outputFile));
                    continue block1;
                }
                continue;
            }
            result.add(new DefaultOutputMetadata(this, this.oldState, outputFile));
        }
        return result;
    }

    private File normalize(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            this.log.debug("Could not normalize file {}", (Object)file, (Object)e);
            return file.getAbsoluteFile();
        }
    }

    public void associate(DefaultInput<?> input, DefaultOutput output) {
        Object inputResource = input.getResource();
        if (!this.processedInputs.containsKey(inputResource)) {
            throw new IllegalStateException("Input is not processed " + inputResource);
        }
        File outputFile = output.getResource();
        DefaultBuildContext.put(this.state.inputOutputs, inputResource, outputFile);
        DefaultBuildContext.put(this.state.outputInputs, outputFile, inputResource);
    }

    private boolean isAssociatedOutput(DefaultInput<?> input, File outputFile) {
        Collection<File> outputs = this.state.inputOutputs.get(input.getResource());
        return outputs != null && outputs.contains(outputFile);
    }

    <I> Iterable<DefaultInputMetadata<I>> getAssociatedInputs(DefaultBuildContextState state, File outputFile, Class<I> clazz) {
        Collection<Object> inputFiles = state.outputInputs.get(outputFile);
        if (inputFiles == null || inputFiles.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DefaultInputMetadata<I>> inputs = new ArrayList<DefaultInputMetadata<I>>();
        for (Object inputFile : inputFiles) {
            if (!clazz.isAssignableFrom(clazz)) continue;
            inputs.add(new DefaultInputMetadata<I>(this, state, clazz.cast(inputFile)));
        }
        return inputs;
    }

    OutputStream newOutputStream(DefaultOutput output) throws IOException {
        return this.workspace.newOutputStream(output.getResource());
    }

    public Iterable<DefaultOutput> getAssociatedOutputs(File inputFile) {
        Collection<File> outputFiles = this.state.inputOutputs.get(inputFile);
        if (outputFiles == null || outputFiles.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DefaultOutput> outputs = new ArrayList<DefaultOutput>();
        for (File outputFile : outputFiles) {
            outputs.add(this.processedOutputs.get(outputFile));
        }
        return outputs;
    }

    Iterable<DefaultOutputMetadata> getAssociatedOutputs(DefaultBuildContextState state, Object inputResource) {
        Collection<File> outputFiles = state.inputOutputs.get(inputResource);
        if (outputFiles == null || outputFiles.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DefaultOutputMetadata> outputs = new ArrayList<DefaultOutputMetadata>();
        for (File outputFile : outputFiles) {
            outputs.add(new DefaultOutputMetadata(this, state, outputFile));
        }
        return outputs;
    }

    public void associateIncludedInput(DefaultInput<?> input, DefaultInput<File> included) {
        DefaultBuildContext.put(this.state.inputIncludedInputs, input.getResource(), included.getResource());
    }

    void addRequirement(DefaultInput<?> input, String qualifier, String localName) {
        this.addRequirement(input, new QualifiedName(qualifier, localName));
    }

    Collection<String> getRequirements(DefaultInputMetadata<?> input, DefaultBuildContextState state, String qualifier) {
        HashSet<String> requirements = new HashSet<String>();
        Collection<QualifiedName> inputRequirements = state.inputRequirements.get(input.getResource());
        if (inputRequirements != null) {
            for (QualifiedName requirement : inputRequirements) {
                if (!qualifier.equals(requirement.getQualifier())) continue;
                requirements.add(requirement.getLocalName());
            }
        }
        return requirements;
    }

    private void addRequirement(DefaultInput<?> input, QualifiedName requirement) {
        this.addInputRequirement(input.getResource(), requirement);
    }

    private void addInputRequirement(Object inputResource, QualifiedName requirement) {
        DefaultBuildContext.put(this.state.requirementInputs, requirement, inputResource);
        DefaultBuildContext.put(this.state.inputRequirements, inputResource, requirement);
    }

    public void addCapability(DefaultOutput output, String qualifier, String localName) {
        DefaultBuildContext.put(this.state.outputCapabilities, output.getResource(), new QualifiedName(qualifier, localName));
    }

    public Collection<String> getOutputCapabilities(File outputFile, String qualifier) {
        Collection<QualifiedName> capabilities = this.state.outputCapabilities.get(outputFile);
        if (capabilities == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (QualifiedName capability : capabilities) {
            if (!qualifier.equals(capability.getQualifier())) continue;
            result.add(capability.getLocalName());
        }
        return result;
    }

    public Iterable<DefaultInputMetadata<File>> getDependentInputs(String qualifier, String localName) {
        Collection<Object> oldInputResources;
        LinkedHashMap<Object, BuildContext.InputMetadata> result = new LinkedHashMap<Object, BuildContext.InputMetadata>();
        QualifiedName requirement = new QualifiedName(qualifier, localName);
        Collection<Object> inputResources = this.state.requirementInputs.get(requirement);
        if (inputResources != null) {
            for (Object inputResource : inputResources) {
                if (!(inputResource instanceof File)) continue;
                result.put(inputResource, this.getProcessedInput((File)inputResource));
            }
        }
        if ((oldInputResources = this.oldState.requirementInputs.get(requirement)) != null) {
            for (Object inputResource : oldInputResources) {
                ResourceHolder<?> oldInputState = this.oldState.inputs.get(inputResource);
                if (!(inputResource instanceof File) || result.containsKey(inputResource) || this.getResourceStatus(oldInputState) == BuildContext.ResourceStatus.REMOVED) continue;
                result.put(inputResource, this.registerInput((File)inputResource));
            }
        }
        return result.values();
    }

    public <T extends Serializable> Serializable setResourceAttribute(Object resource, String key, T value) {
        Map<String, Serializable> attributes = this.state.resourceAttributes.get(resource);
        if (attributes == null) {
            attributes = new LinkedHashMap<String, Serializable>();
            this.state.resourceAttributes.put(resource, attributes);
        }
        attributes.put(key, value);
        Map<String, Serializable> oldAttributes = this.oldState.resourceAttributes.get(resource);
        return oldAttributes != null ? oldAttributes.get(key) : null;
    }

    public <T extends Serializable> T getResourceAttribute(Object resource, String key, boolean previous, Class<T> clazz) {
        Map<String, Serializable> attributes = (previous ? this.oldState : this.state).resourceAttributes.get(resource);
        return (T)(attributes != null ? (Serializable)clazz.cast(attributes.get(key)) : null);
    }

    public void addMessage(Object resource, int line, int column, String message, BuildContext.Severity severity, Throwable cause) {
        DefaultBuildContext.put(this.state.resourceMessages, resource, new Message(line, column, message, severity, cause));
        this.log(resource, line, column, message, severity, cause);
    }

    protected void log(Object resource, int line, int column, String message, BuildContext.Severity severity, Throwable cause) {
        switch (severity) {
            case ERROR: {
                this.log.error("{}:[{}:{}] {}", new Object[]{resource.toString(), line, column, message, cause});
                break;
            }
            case WARNING: {
                this.log.warn("{}:[{}:{}] {}", new Object[]{resource.toString(), line, column, message, cause});
                break;
            }
            default: {
                this.log.info("{}:[{}:{}] {}", new Object[]{resource.toString(), line, column, message, cause});
            }
        }
    }

    Collection<Message> getMessages(Object resource) {
        if (this.processedInputs.containsKey(resource) || this.processedOutputs.containsKey(resource)) {
            return this.state.resourceMessages.get(resource);
        }
        return this.oldState.resourceMessages.get(resource);
    }

    public void commit() throws BuildFailureException, IOException {
        Object resource;
        this.deleteStaleOutputs(true);
        HashMap<Object, Collection<Message>> newMessages = new HashMap<Object, Collection<Message>>(this.state.resourceMessages);
        HashMap<Object, Collection<Message>> recordedMessages = new HashMap<Object, Collection<Message>>();
        for (Object object : this.oldState.inputs.keySet()) {
            Collection<QualifiedName> requirements;
            Collection<Object> includedInputs;
            if (!this.isRegistered(object)) {
                this.clearMessages(object);
                continue;
            }
            if (this.processedInputs.containsKey(object)) continue;
            Collection<File> associatedOutputs = this.oldState.inputOutputs.get(object);
            if (associatedOutputs != null) {
                for (File outputFile : associatedOutputs) {
                    this.carryOverOutput(object, outputFile);
                    this.carryOverMessages(outputFile, recordedMessages);
                }
            }
            if ((includedInputs = this.oldState.inputIncludedInputs.get(object)) != null) {
                this.state.inputIncludedInputs.put(object, new LinkedHashSet<Object>(includedInputs));
                for (Object includedInput : includedInputs) {
                    ResourceHolder<?> oldHolder = this.oldState.includedInputs.get(includedInput);
                    this.state.includedInputs.put(oldHolder.getResource(), oldHolder);
                }
            }
            if ((requirements = this.oldState.inputRequirements.get(object)) != null) {
                for (QualifiedName requirement : requirements) {
                    this.addInputRequirement(object, requirement);
                }
            }
            this.carryOverMessages(object, recordedMessages);
            Map<String, Serializable> attributes = this.oldState.resourceAttributes.get(object);
            if (attributes == null) continue;
            this.state.resourceAttributes.put(object, attributes);
        }
        for (ResourceHolder resourceHolder : this.state.inputs.values()) {
            if (this.getResourceStatus(resourceHolder) == BuildContext.ResourceStatus.UNMODIFIED) continue;
            throw new IllegalStateException("Unexpected input change " + resourceHolder.getResource());
        }
        for (File file : this.oldState.outputs.keySet()) {
            if (!this.uptodateOutputs.contains(file)) continue;
            this.carryOverOutput(file);
            this.carryOverMessages(file, recordedMessages);
        }
        for (File file : this.processedOutputs.keySet()) {
            if (this.state.outputs.get(file) != null) continue;
            this.state.outputs.put(file, this.newFileState(file));
        }
        if (this.stateFile != null) {
            this.state.storeTo(this.stateFile);
        }
        if (!recordedMessages.isEmpty()) {
            this.log.info("Replaying recorded messages...");
            for (Map.Entry entry : this.state.resourceMessages.entrySet()) {
                resource = entry.getKey();
                for (Message message : (Collection)entry.getValue()) {
                    this.log(resource, message.line, message.column, message.message, message.severity, message.cause);
                }
            }
        }
        if (this.messageSink != null) {
            for (Map.Entry entry : newMessages.entrySet()) {
                resource = entry.getKey();
                for (Message message : (Collection)entry.getValue()) {
                    this.messageSink.message(resource, message.line, message.column, message.message, this.toMessageSinkSeverity(message.severity), message.cause);
                }
            }
        } else {
            int errorCount = 0;
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<Object, Collection<Message>> entry : this.state.resourceMessages.entrySet()) {
                Object resource3 = entry.getKey();
                for (Message message : entry.getValue()) {
                    if (message.severity != BuildContext.Severity.ERROR) continue;
                    ++errorCount;
                    stringBuilder.append(String.format("%s:[%d:%d] %s\n", resource3.toString(), message.line, message.column, message.message));
                }
            }
            if (errorCount > 0) {
                throw this.newBuildFailureException(errorCount + " error(s) encountered:\n" + stringBuilder.toString());
            }
        }
    }

    private void clearMessages(Object resource) {
        if (this.messageSink != null) {
            this.messageSink.clearMessages(resource);
        }
    }

    private MessageSink.Severity toMessageSinkSeverity(BuildContext.Severity severity) {
        switch (severity) {
            case ERROR: {
                return MessageSink.Severity.ERROR;
            }
            case WARNING: {
                return MessageSink.Severity.WARNING;
            }
            case INFO: {
                return MessageSink.Severity.INFO;
            }
        }
        throw new IllegalArgumentException();
    }

    private FileState newFileState(File file) {
        return this.newFileState(file, file.lastModified(), file.length());
    }

    private FileState newFileState(File file, long lastModified, long length) {
        if (!this.workspace.isPresent(file)) {
            throw new IllegalArgumentException("File does not exist or cannot be read " + file);
        }
        return new FileState(file, lastModified, length);
    }

    private void carryOverMessages(Object resource, Map<Object, Collection<Message>> recordedMessages) {
        Collection<Message> messages = this.oldState.resourceMessages.get(resource);
        if (messages != null && !messages.isEmpty()) {
            this.state.resourceMessages.put(resource, new ArrayList<Message>(messages));
            DefaultBuildContext.putAll(recordedMessages, resource, messages);
        }
    }

    protected void carryOverOutput(Object inputResource, File outputFile) {
        this.carryOverOutput(outputFile);
        DefaultBuildContext.put(this.state.inputOutputs, inputResource, outputFile);
        DefaultBuildContext.put(this.state.outputInputs, outputFile, inputResource);
    }

    protected void carryOverOutput(File outputFile) {
        Map<String, Serializable> attributes;
        this.state.outputs.put(outputFile, this.oldState.outputs.get(outputFile));
        Collection<QualifiedName> capabilities = this.oldState.outputCapabilities.get(outputFile);
        if (capabilities != null) {
            this.state.outputCapabilities.put(outputFile, new LinkedHashSet<QualifiedName>(capabilities));
        }
        if ((attributes = this.oldState.resourceAttributes.get(outputFile)) != null) {
            this.state.resourceAttributes.put(outputFile, attributes);
        }
    }

    public boolean isProcessingRequired() {
        if (this.escalated || !this.processedInputs.isEmpty() || !this.processedOutputs.isEmpty()) {
            return true;
        }
        for (Object object : this.state.inputs.keySet()) {
            ResourceHolder<?> oldInputState = this.oldState.inputs.get(object);
            if (oldInputState != null && this.getResourceStatus(oldInputState) == BuildContext.ResourceStatus.UNMODIFIED) continue;
            return true;
        }
        for (Object object : this.oldState.inputs.keySet()) {
            if (this.isRegistered(object)) continue;
            return true;
        }
        for (ResourceHolder resourceHolder : this.oldState.includedInputs.values()) {
            if (this.getResourceStatus(resourceHolder) == BuildContext.ResourceStatus.UNMODIFIED) continue;
            return true;
        }
        for (ResourceHolder resourceHolder : this.oldState.outputs.values()) {
            if (this.getResourceStatus(resourceHolder) == BuildContext.ResourceStatus.UNMODIFIED) continue;
            return true;
        }
        return false;
    }

    protected abstract BuildFailureException newBuildFailureException(String var1);
}

