/*
 * Decompiled with CFR 0.152.
 */
package io.takari.incrementalbuild.maven.testing;

import io.takari.incrementalbuild.workspace.MessageSink;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IncrementalBuildLog {
    private final List<File> registeredOutputs = new ArrayList<File>();
    private final List<File> deletedOutputs = new ArrayList<File>();
    private final List<File> carriedOverOutputs = new ArrayList<File>();
    private final Map<File, List<String>> resourceMessages = new HashMap<File, List<String>>();

    void addRegisterOutput(File outputFile) {
        this.registeredOutputs.add(outputFile);
    }

    void addDeletedOutput(File outputFile) {
        this.deletedOutputs.add(outputFile);
    }

    void addCarryoverOutput(File outputFile) {
        this.carriedOverOutputs.add(outputFile);
    }

    void message(Object resource, int line, int column, String message, MessageSink.Severity severity, Throwable cause) {
        if (!(resource instanceof File)) {
            throw new IllegalArgumentException();
        }
        File file = (File)resource;
        String msg = String.format("%s %s [%d:%d] %s", severity.name(), file.getName(), line, column, message);
        List<String> messages = this.resourceMessages.get(file);
        if (messages == null) {
            messages = new ArrayList<String>();
            this.resourceMessages.put(file, messages);
        }
        messages.add(msg);
    }

    public Collection<File> getRegisteredOutputs() {
        return this.registeredOutputs;
    }

    public Collection<File> getDeletedOutputs() {
        return this.deletedOutputs;
    }

    public Collection<File> getCarriedOverOutputs() {
        return this.carriedOverOutputs;
    }

    public Collection<String> getMessages(File inputFile) {
        List<String> messages = this.resourceMessages.get(inputFile);
        return messages != null ? messages : Collections.emptyList();
    }

    public void clear() {
        this.registeredOutputs.clear();
        this.deletedOutputs.clear();
        this.carriedOverOutputs.clear();
        this.resourceMessages.clear();
    }
}

