/*
 * Decompiled with CFR 0.152.
 */
package io.takari.incrementalbuild.aggregator.internal;

import io.takari.incrementalbuild.ResourceMetadata;
import io.takari.incrementalbuild.aggregator.InputAggregator;
import io.takari.incrementalbuild.aggregator.InputSet;
import io.takari.incrementalbuild.aggregator.MetadataAggregator;
import io.takari.incrementalbuild.aggregator.internal.DefaultAggregatorBuildContext;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class DefaultInputSet
implements InputSet {
    private final DefaultAggregatorBuildContext context;
    private final Set<File> inputs = new LinkedHashSet<File>();

    DefaultInputSet(DefaultAggregatorBuildContext context) {
        this.context = context;
    }

    @Override
    public File addInput(File inputFile) throws IOException {
        inputFile = this.context.registerInput(inputFile).getResource();
        this.inputs.add(inputFile);
        return inputFile;
    }

    @Override
    public Iterable<File> addInputs(File basedir, Collection<String> includes, Collection<String> excludes) throws IOException {
        LinkedHashSet<File> inputs = new LinkedHashSet<File>();
        for (ResourceMetadata resourceMetadata : this.context.registerInputs(basedir, includes, excludes)) {
            this.inputs.add((File)resourceMetadata.getResource());
            inputs.add((File)resourceMetadata.getResource());
        }
        return inputs;
    }

    @Override
    public boolean aggregateIfNecessary(File outputFile, InputAggregator aggregator) throws IOException {
        return this.context.aggregateIfNecessary(this.inputs, outputFile, aggregator);
    }

    @Override
    public <T extends Serializable> boolean aggregateIfNecessary(File outputFile, MetadataAggregator<T> aggregator) throws IOException {
        return this.context.aggregateIfNecessary(this.inputs, outputFile, aggregator);
    }
}

