/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.servlet.extensions;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import io.swagger.annotations.Extension;
import io.swagger.annotations.ResponseHeader;
import io.swagger.converter.ModelConverters;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.SecurityRequirement;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.servlet.ReaderContext;
import io.swagger.servlet.extensions.ReaderExtension;
import io.swagger.util.BaseReaderUtils;
import io.swagger.util.ParameterProcessor;
import io.swagger.util.PathUtils;
import io.swagger.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletReaderExtension
implements ReaderExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletReaderExtension.class);
    private static final String SUCCESSFUL_OPERATION = "successful operation";

    private static <T> List<T> parseAnnotationValues(String str, Function<String, T> processor) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (String item : Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)str)) {
            result.add(processor.apply((Object)item));
        }
        return result;
    }

    private static List<String> parseStringValues(String str) {
        return ServletReaderExtension.parseAnnotationValues(str, new Function<String, String>(){

            public String apply(String value) {
                return value;
            }
        });
    }

    private static List<Scheme> parseSchemes(String schemes) {
        ArrayList<Scheme> result = new ArrayList<Scheme>();
        for (String item : StringUtils.trimToEmpty((String)schemes).split(",")) {
            Scheme scheme = Scheme.forValue((String)StringUtils.trimToNull((String)item));
            if (scheme == null || result.contains(scheme)) continue;
            result.add(scheme);
        }
        return result;
    }

    private static List<SecurityRequirement> parseAuthorizations(Authorization[] authorizations) {
        ArrayList<SecurityRequirement> result = new ArrayList<SecurityRequirement>();
        for (Authorization auth : authorizations) {
            if (!StringUtils.isNotEmpty((CharSequence)auth.value())) continue;
            SecurityRequirement security = new SecurityRequirement();
            security.setName(auth.value());
            for (AuthorizationScope scope : auth.scopes()) {
                if (!StringUtils.isNotEmpty((CharSequence)scope.scope())) continue;
                security.addScope(scope.scope());
            }
            result.add(security);
        }
        return result;
    }

    private static Map<String, Property> parseResponseHeaders(ReaderContext context, ResponseHeader[] headers) {
        HashMap<String, Property> responseHeaders = null;
        for (ResponseHeader header : headers) {
            Property property;
            Class cls;
            String name = header.name();
            if (!StringUtils.isNotEmpty((CharSequence)name)) continue;
            if (responseHeaders == null) {
                responseHeaders = new HashMap<String, Property>();
            }
            if (ReflectionUtils.isVoid((Type)(cls = header.response())) || (property = ModelConverters.getInstance().readAsProperty((Type)cls)) == null) continue;
            Property responseProperty = ContainerWrapper.wrapContainer(header.responseContainer(), property, ContainerWrapper.ARRAY, ContainerWrapper.LIST, ContainerWrapper.SET);
            responseProperty.setDescription(header.description());
            responseHeaders.put(name, responseProperty);
            ServletReaderExtension.appendModels(context.getSwagger(), cls);
        }
        return responseHeaders;
    }

    private static void appendModels(Swagger swagger, Type type) {
        Map models = ModelConverters.getInstance().readAll(type);
        for (Map.Entry entry : models.entrySet()) {
            swagger.model((String)entry.getKey(), (Model)entry.getValue());
        }
    }

    private static boolean isValidResponse(Type type) {
        JavaType javaType = TypeFactory.defaultInstance().constructType(type);
        return !ReflectionUtils.isVoid((Type)javaType);
    }

    private static Type getResponseType(Method method) {
        ApiOperation apiOperation = (ApiOperation)ReflectionUtils.getAnnotation((Method)method, ApiOperation.class);
        if (apiOperation != null && !ReflectionUtils.isVoid((Type)apiOperation.response())) {
            return apiOperation.response();
        }
        return method.getGenericReturnType();
    }

    private static String getResponseContainer(ApiOperation apiOperation) {
        return apiOperation == null ? null : (String)StringUtils.defaultIfBlank((CharSequence)apiOperation.responseContainer(), null);
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public boolean isReadable(ReaderContext context) {
        Api apiAnnotation = context.getCls().getAnnotation(Api.class);
        return apiAnnotation != null && (context.isReadHidden() || !apiAnnotation.hidden());
    }

    @Override
    public void applyConsumes(ReaderContext context, Operation operation, Method method) {
        ArrayList<String> consumes = new ArrayList<String>();
        ApiOperation apiOperation = (ApiOperation)ReflectionUtils.getAnnotation((Method)method, ApiOperation.class);
        if (apiOperation != null) {
            consumes.addAll(ServletReaderExtension.parseStringValues(apiOperation.consumes()));
        }
        if (consumes.isEmpty()) {
            Api apiAnnotation = context.getCls().getAnnotation(Api.class);
            if (apiAnnotation != null) {
                consumes.addAll(ServletReaderExtension.parseStringValues(apiAnnotation.consumes()));
            }
            consumes.addAll(context.getParentConsumes());
        }
        for (String consume : consumes) {
            operation.consumes(consume);
        }
    }

    @Override
    public void applyProduces(ReaderContext context, Operation operation, Method method) {
        ArrayList<String> produces = new ArrayList<String>();
        ApiOperation apiOperation = (ApiOperation)ReflectionUtils.getAnnotation((Method)method, ApiOperation.class);
        if (apiOperation != null) {
            produces.addAll(ServletReaderExtension.parseStringValues(apiOperation.produces()));
        }
        if (produces.isEmpty()) {
            Api apiAnnotation = context.getCls().getAnnotation(Api.class);
            if (apiAnnotation != null) {
                produces.addAll(ServletReaderExtension.parseStringValues(apiAnnotation.produces()));
            }
            produces.addAll(context.getParentProduces());
        }
        for (String produce : produces) {
            operation.produces(produce);
        }
    }

    @Override
    public String getHttpMethod(ReaderContext context, Method method) {
        ApiOperation apiOperation = (ApiOperation)ReflectionUtils.getAnnotation((Method)method, ApiOperation.class);
        return apiOperation == null || StringUtils.isEmpty((CharSequence)apiOperation.httpMethod()) ? context.getParentHttpMethod() : apiOperation.httpMethod();
    }

    @Override
    public String getPath(ReaderContext context, Method method) {
        Api apiAnnotation = context.getCls().getAnnotation(Api.class);
        ApiOperation apiOperation = (ApiOperation)ReflectionUtils.getAnnotation((Method)method, ApiOperation.class);
        String operationPath = apiOperation == null ? null : apiOperation.nickname();
        return PathUtils.collectPath((String[])new String[]{context.getParentPath(), apiAnnotation == null ? null : apiAnnotation.value(), StringUtils.isBlank((CharSequence)operationPath) ? method.getName() : operationPath});
    }

    @Override
    public void applyOperationId(Operation operation, Method method) {
        ApiOperation apiOperation = (ApiOperation)ReflectionUtils.getAnnotation((Method)method, ApiOperation.class);
        if (apiOperation != null && StringUtils.isNotBlank((CharSequence)apiOperation.nickname())) {
            operation.operationId(apiOperation.nickname());
        } else {
            operation.operationId(method.getName());
        }
    }

    @Override
    public void applySummary(Operation operation, Method method) {
        ApiOperation apiOperation = (ApiOperation)ReflectionUtils.getAnnotation((Method)method, ApiOperation.class);
        if (apiOperation != null && StringUtils.isNotBlank((CharSequence)apiOperation.value())) {
            operation.summary(apiOperation.value());
        }
    }

    @Override
    public void applyDescription(Operation operation, Method method) {
        ApiOperation apiOperation = (ApiOperation)ReflectionUtils.getAnnotation((Method)method, ApiOperation.class);
        if (apiOperation != null && StringUtils.isNotBlank((CharSequence)apiOperation.notes())) {
            operation.description(apiOperation.notes());
        }
    }

    @Override
    public void applySchemes(ReaderContext context, Operation operation, Method method) {
        ArrayList<Scheme> schemes = new ArrayList<Scheme>();
        ApiOperation apiOperation = (ApiOperation)ReflectionUtils.getAnnotation((Method)method, ApiOperation.class);
        Api apiAnnotation = context.getCls().getAnnotation(Api.class);
        if (apiOperation != null) {
            schemes.addAll(ServletReaderExtension.parseSchemes(apiOperation.protocols()));
        }
        if (schemes.isEmpty() && apiAnnotation != null) {
            schemes.addAll(ServletReaderExtension.parseSchemes(apiAnnotation.protocols()));
        }
        for (Scheme scheme : schemes) {
            operation.scheme(scheme);
        }
    }

    @Override
    public void setDeprecated(Operation operation, Method method) {
        if (ReflectionUtils.getAnnotation((Method)method, Deprecated.class) != null) {
            operation.deprecated(Boolean.valueOf(true));
        }
    }

    @Override
    public void applySecurityRequirements(ReaderContext context, Operation operation, Method method) {
        ArrayList<SecurityRequirement> securityRequirements = new ArrayList<SecurityRequirement>();
        ApiOperation apiOperation = (ApiOperation)ReflectionUtils.getAnnotation((Method)method, ApiOperation.class);
        Api apiAnnotation = context.getCls().getAnnotation(Api.class);
        if (apiOperation != null) {
            securityRequirements.addAll(ServletReaderExtension.parseAuthorizations(apiOperation.authorizations()));
        }
        if (securityRequirements.isEmpty() && apiAnnotation != null) {
            securityRequirements.addAll(ServletReaderExtension.parseAuthorizations(apiAnnotation.authorizations()));
        }
        for (SecurityRequirement securityRequirement : securityRequirements) {
            operation.security(securityRequirement);
        }
    }

    @Override
    public void applyTags(ReaderContext context, Operation operation, Method method) {
        ArrayList<String> tags = new ArrayList<String>();
        Api apiAnnotation = context.getCls().getAnnotation(Api.class);
        Predicate<String> predicate = new Predicate<String>(){

            public boolean apply(String input) {
                return StringUtils.isNotBlank((CharSequence)input);
            }

            public boolean test(String input) {
                return this.apply(input);
            }
        };
        if (apiAnnotation != null) {
            tags.addAll(Collections2.filter(Arrays.asList(apiAnnotation.tags()), (Predicate)predicate));
        }
        tags.addAll(context.getParentTags());
        ApiOperation apiOperation = (ApiOperation)ReflectionUtils.getAnnotation((Method)method, ApiOperation.class);
        if (apiOperation != null) {
            tags.addAll(Collections2.filter(Arrays.asList(apiOperation.tags()), (Predicate)predicate));
        }
        for (String tag : tags) {
            operation.tag(tag);
        }
    }

    @Override
    public void applyResponses(ReaderContext context, Operation operation, Method method) {
        ApiResponses responseAnnotation;
        Property property;
        Type responseType;
        HashMap<Integer, Response> result = new HashMap<Integer, Response>();
        ApiOperation apiOperation = (ApiOperation)ReflectionUtils.getAnnotation((Method)method, ApiOperation.class);
        if (apiOperation != null && StringUtils.isNotBlank((CharSequence)apiOperation.responseReference())) {
            Response response = new Response().description(SUCCESSFUL_OPERATION);
            response.schema((Property)new RefProperty(apiOperation.responseReference()));
            result.put(apiOperation.code(), response);
        }
        if (ServletReaderExtension.isValidResponse(responseType = ServletReaderExtension.getResponseType(method)) && (property = ModelConverters.getInstance().readAsProperty(responseType)) != null) {
            Property responseProperty = ContainerWrapper.wrapContainer(ServletReaderExtension.getResponseContainer(apiOperation), property, new ContainerWrapper[0]);
            int n = apiOperation == null ? 200 : apiOperation.code();
            Map defaultResponseHeaders = apiOperation == null ? Collections.emptyMap() : ServletReaderExtension.parseResponseHeaders(context, apiOperation.responseHeaders());
            Response response = new Response().description(SUCCESSFUL_OPERATION).schema(responseProperty).headers(defaultResponseHeaders);
            result.put(n, response);
            ServletReaderExtension.appendModels(context.getSwagger(), responseType);
        }
        if ((responseAnnotation = (ApiResponses)ReflectionUtils.getAnnotation((Method)method, ApiResponses.class)) != null) {
            for (ApiResponse apiResponse : responseAnnotation.value()) {
                Map<String, Property> responseHeaders = ServletReaderExtension.parseResponseHeaders(context, apiResponse.responseHeaders());
                Response response = new Response().description(apiResponse.message()).headers(responseHeaders);
                if (StringUtils.isNotEmpty((CharSequence)apiResponse.reference())) {
                    response.schema((Property)new RefProperty(apiResponse.reference()));
                } else if (!ReflectionUtils.isVoid((Type)apiResponse.response())) {
                    Class type = apiResponse.response();
                    Property property2 = ModelConverters.getInstance().readAsProperty((Type)type);
                    if (property2 != null) {
                        response.schema(ContainerWrapper.wrapContainer(apiResponse.responseContainer(), property2, new ContainerWrapper[0]));
                        ServletReaderExtension.appendModels(context.getSwagger(), type);
                    }
                }
                result.put(apiResponse.code(), response);
            }
        }
        for (Map.Entry entry : result.entrySet()) {
            if ((Integer)entry.getKey() == 0) {
                operation.defaultResponse((Response)entry.getValue());
                continue;
            }
            operation.response(((Integer)entry.getKey()).intValue(), (Response)entry.getValue());
        }
    }

    @Override
    public void applyParameters(ReaderContext context, Operation operation, Type type, Annotation[] annotations) {
    }

    @Override
    public void applyImplicitParameters(ReaderContext context, Operation operation, Method method) {
        ApiImplicitParams implicitParams = (ApiImplicitParams)ReflectionUtils.getAnnotation((Method)method, ApiImplicitParams.class);
        if (implicitParams != null && implicitParams.value().length > 0) {
            for (ApiImplicitParam param : implicitParams.value()) {
                Parameter p = this.readImplicitParam(context.getSwagger(), param);
                if (p == null) continue;
                operation.parameter(p);
            }
        }
    }

    @Override
    public void applyExtensions(ReaderContext context, Operation operation, Method method) {
        ApiOperation apiOperation = (ApiOperation)ReflectionUtils.getAnnotation((Method)method, ApiOperation.class);
        if (apiOperation != null) {
            operation.getVendorExtensions().putAll(BaseReaderUtils.parseExtensions((Extension[])apiOperation.extensions()));
        }
    }

    private Parameter readImplicitParam(Swagger swagger, ApiImplicitParam param) {
        Parameter p = ParameterFactory.createParam(param.paramType());
        if (p == null) {
            return null;
        }
        Type type = ReflectionUtils.typeFromString((String)param.dataType());
        return ParameterProcessor.applyAnnotations((Swagger)swagger, (Parameter)p, (Type)(type == null ? String.class : type), Collections.singletonList(param));
    }

    static enum ContainerWrapper {
        LIST("list"){

            @Override
            protected Property doWrap(Property property) {
                return new ArrayProperty(property);
            }
        }
        ,
        ARRAY("array"){

            @Override
            protected Property doWrap(Property property) {
                return new ArrayProperty(property);
            }
        }
        ,
        MAP("map"){

            @Override
            protected Property doWrap(Property property) {
                return new MapProperty(property);
            }
        }
        ,
        SET("set"){

            @Override
            protected Property doWrap(Property property) {
                ArrayProperty arrayProperty = new ArrayProperty(property);
                arrayProperty.setUniqueItems(Boolean.valueOf(true));
                return arrayProperty;
            }
        };

        private final String container;

        private ContainerWrapper(String container) {
            this.container = container;
        }

        public static Property wrapContainer(String container, Property property, ContainerWrapper ... allowed) {
            EnumSet<ContainerWrapper> tmp = allowed.length > 0 ? EnumSet.copyOf(Arrays.asList(allowed)) : EnumSet.allOf(ContainerWrapper.class);
            for (ContainerWrapper wrapper : tmp) {
                Property prop = wrapper.wrap(container, property);
                if (prop == null) continue;
                return prop;
            }
            return property;
        }

        public Property wrap(String container, Property property) {
            if (this.container.equalsIgnoreCase(container)) {
                return this.doWrap(property);
            }
            return null;
        }

        protected abstract Property doWrap(Property var1);
    }

    static enum ParameterFactory {
        PATH("path"){

            @Override
            protected Parameter create() {
                return new PathParameter();
            }
        }
        ,
        QUERY("query"){

            @Override
            protected Parameter create() {
                return new QueryParameter();
            }
        }
        ,
        FORM("form"){

            @Override
            protected Parameter create() {
                return new FormParameter();
            }
        }
        ,
        FORM_DATA("formData"){

            @Override
            protected Parameter create() {
                return new FormParameter();
            }
        }
        ,
        HEADER("header"){

            @Override
            protected Parameter create() {
                return new HeaderParameter();
            }
        }
        ,
        BODY("body"){

            @Override
            protected Parameter create() {
                return new BodyParameter();
            }
        };

        private final String paramType;

        private ParameterFactory(String paramType) {
            this.paramType = paramType;
        }

        public static Parameter createParam(String paramType) {
            for (ParameterFactory item : ParameterFactory.values()) {
                if (!item.paramType.equalsIgnoreCase(paramType)) continue;
                return item.create();
            }
            LOGGER.warn("Unknown implicit parameter type: [" + paramType + "]");
            return null;
        }

        protected abstract Parameter create();
    }
}

