/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model.functions;

import io.sundr.model.ClassRef;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeDefBuilder;
import io.sundr.model.repo.DefinitionRepository;
import io.sundr.utils.Predicates;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class GetDefinition
implements Function<ClassRef, TypeDef> {
    public static GetDefinition FUNCTION = new GetDefinition();

    public static TypeDef of(ClassRef classRef) {
        return FUNCTION.apply(classRef);
    }

    @Override
    public TypeDef apply(ClassRef t) {
        String ownerClassName;
        String fullyQualifiedName = t.getFullyQualifiedName();
        TypeDef def = DefinitionRepository.getRepository().getDefinition(fullyQualifiedName);
        if (def != null) {
            return def;
        }
        Predicate<String> isLowerCase = w -> Character.isUpperCase(w.charAt(0));
        Predicate inPackage = Predicates.until(isLowerCase);
        Predicate outOfPackage = Predicates.after(isLowerCase);
        String packageName = Arrays.stream(fullyQualifiedName.split("\\.")).filter(inPackage).collect(Collectors.joining("."));
        String className = Arrays.stream(fullyQualifiedName.split("\\.")).filter(outOfPackage).collect(Collectors.joining("."));
        String string = ownerClassName = className.contains(".") ? className.substring(0, className.indexOf(".")) : null;
        if (ownerClassName != null) {
            className = className.substring(ownerClassName.length() + 1);
            return ((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder().withName(className)).withPackageName(packageName)).withOuterTypeName(packageName + "." + ownerClassName)).build();
        }
        return ((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder().withName(className)).withPackageName(packageName)).build();
    }
}

