/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;

public class Modifiers {
    private final boolean _private;
    private final boolean _protected;
    private final boolean _public;
    private final boolean _abstract;
    private final boolean _final;
    private final boolean _native;
    private final boolean _static;
    private final boolean _synchronized;
    private final boolean _transient;

    public Modifiers() {
        this(false, false, false, false, false, false, false, false, false);
    }

    public Modifiers(boolean _private, boolean _protected, boolean _public, boolean _abstract, boolean _final, boolean _native, boolean _static, boolean _synchronized, boolean _transient) {
        this._private = _private;
        this._protected = _protected;
        this._public = _public;
        this._abstract = _abstract;
        this._final = _final;
        this._native = _native;
        this._static = _static;
        this._synchronized = _synchronized;
        this._transient = _transient;
    }

    public int toInt() {
        int result = 0;
        if (this._private) {
            result |= 2;
        }
        if (this._protected) {
            result |= 4;
        }
        if (this._public) {
            result |= 1;
        }
        if (this._abstract) {
            result |= 0x400;
        }
        if (this._final) {
            result |= 0x10;
        }
        if (this._native) {
            result |= 0x100;
        }
        if (this._static) {
            result |= 8;
        }
        if (this._transient) {
            result |= 0x80;
        }
        return result;
    }

    public static Modifiers create() {
        return new Modifiers(false, false, false, false, false, false, false, false, false);
    }

    public static Modifiers from(int modifiers) {
        return new Modifiers(Modifier.isPrivate(modifiers), Modifier.isProtected(modifiers), Modifier.isPublic(modifiers), Modifier.isAbstract(modifiers), Modifier.isFinal(modifiers), Modifier.isNative(modifiers), Modifier.isStatic(modifiers), Modifier.isSynchronized(modifiers), Modifier.isTransient(modifiers));
    }

    public static Modifiers from(Collection<javax.lang.model.element.Modifier> modifiers) {
        if (modifiers == null) {
            return Modifiers.create();
        }
        return Modifiers.from(modifiers.stream().distinct().map(m -> {
            switch (m) {
                case ABSTRACT: {
                    return 1024;
                }
                case FINAL: {
                    return 16;
                }
                case NATIVE: {
                    return 256;
                }
                case PRIVATE: {
                    return 2;
                }
                case PROTECTED: {
                    return 4;
                }
                case PUBLIC: {
                    return 1;
                }
                case STATIC: {
                    return 8;
                }
                case SYNCHRONIZED: {
                    return 32;
                }
                case TRANSIENT: {
                    return 128;
                }
            }
            return 0;
        }).reduce(0, (result, m) -> result | m));
    }

    public static Modifiers from(javax.lang.model.element.Modifier ... modifiers) {
        return Modifiers.from(Arrays.asList(modifiers));
    }

    public boolean isPrivate() {
        return this._private;
    }

    public boolean isProtected() {
        return this._protected;
    }

    public boolean isPublic() {
        return this._public;
    }

    public boolean isAbstract() {
        return this._abstract;
    }

    public boolean isFinal() {
        return this._final;
    }

    public boolean isNative() {
        return this._native;
    }

    public boolean isStatic() {
        return this._static;
    }

    public boolean isSynchronized() {
        return this._synchronized;
    }

    public boolean isTransient() {
        return this._transient;
    }

    public int hashCode() {
        return this.toInt();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Modifiers other = (Modifiers)obj;
        return this.toInt() == other.toInt();
    }
}

