/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.client.util.ObjectCache;
import org.apache.pulsar.common.protocol.ByteBufPair;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.common.util.keystoretls.KeyStoreSSLContext;
import org.apache.pulsar.common.util.keystoretls.NettySSLContextAutoRefreshBuilder;
import org.apache.pulsar.common.util.netty.NettyFutureUtil;
import org.apache.pulsar.shade.io.netty.channel.Channel;
import org.apache.pulsar.shade.io.netty.channel.ChannelHandler;
import org.apache.pulsar.shade.io.netty.channel.ChannelInitializer;
import org.apache.pulsar.shade.io.netty.channel.socket.SocketChannel;
import org.apache.pulsar.shade.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.apache.pulsar.shade.io.netty.handler.flush.FlushConsolidationHandler;
import org.apache.pulsar.shade.io.netty.handler.proxy.Socks5ProxyHandler;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslContext;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslHandler;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslProvider;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarChannelInitializer
extends ChannelInitializer<SocketChannel> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PulsarChannelInitializer.class);
    public static final String TLS_HANDLER = "tls";
    private final Supplier<ClientCnx> clientCnxSupplier;
    private final boolean tlsEnabled;
    private final boolean tlsHostnameVerificationEnabled;
    private final boolean tlsEnabledWithKeyStore;
    private final InetSocketAddress socks5ProxyAddress;
    private final String socks5ProxyUsername;
    private final String socks5ProxyPassword;
    private final ClientConfigurationData conf;
    private Map<String, Supplier<SslContext>> sslContextSupplierMap;
    private Map<String, NettySSLContextAutoRefreshBuilder> nettySSLContextAutoRefreshBuilderMap;
    private static final long TLS_CERTIFICATE_CACHE_MILLIS = TimeUnit.MINUTES.toMillis(1L);

    public PulsarChannelInitializer(ClientConfigurationData conf, Supplier<ClientCnx> clientCnxSupplier) throws Exception {
        this.clientCnxSupplier = clientCnxSupplier;
        this.tlsEnabled = conf.isUseTls();
        this.tlsHostnameVerificationEnabled = conf.isTlsHostnameVerificationEnable();
        this.socks5ProxyAddress = conf.getSocks5ProxyAddress();
        this.socks5ProxyUsername = conf.getSocks5ProxyUsername();
        this.socks5ProxyPassword = conf.getSocks5ProxyPassword();
        this.tlsEnabledWithKeyStore = conf.isUseKeyStoreTls();
        this.conf = conf.clone();
        this.sslContextSupplierMap = new ConcurrentHashMap<String, Supplier<SslContext>>();
        this.nettySSLContextAutoRefreshBuilderMap = new ConcurrentHashMap<String, NettySSLContextAutoRefreshBuilder>();
    }

    @Override
    public void initChannel(SocketChannel ch) throws Exception {
        ch.pipeline().addLast("consolidation", (ChannelHandler)new FlushConsolidationHandler(1024, true));
        ch.pipeline().addLast("ByteBufPairEncoder", (ChannelHandler)ByteBufPair.getEncoder(this.tlsEnabled));
        ch.pipeline().addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(5253120, 0, 4, 0, 4));
        ChannelHandler clientCnx = this.clientCnxSupplier.get();
        ch.pipeline().addLast("handler", clientCnx);
    }

    private NettySSLContextAutoRefreshBuilder getNettySSLContextAutoRefreshBuilder(String host) throws PulsarClientException {
        if (this.tlsEnabledWithKeyStore) {
            AuthenticationDataProvider authData1 = this.conf.getAuthentication().getAuthData(host);
            if (StringUtils.isBlank(this.conf.getTlsTrustStorePath())) {
                throw new PulsarClientException("Failed to create TLS context, the tlsTrustStorePath need to be configured if useKeyStoreTls enabled");
            }
            return this.nettySSLContextAutoRefreshBuilderMap.computeIfAbsent(host, key -> new NettySSLContextAutoRefreshBuilder(this.conf.getSslProvider(), this.conf.isTlsAllowInsecureConnection(), this.conf.getTlsTrustStoreType(), this.conf.getTlsTrustStorePath(), this.conf.getTlsTrustStorePassword(), this.conf.getTlsKeyStoreType(), this.conf.getTlsKeyStorePath(), this.conf.getTlsKeyStorePassword(), this.conf.getTlsCiphers(), this.conf.getTlsProtocols(), TLS_CERTIFICATE_CACHE_MILLIS, authData1));
        }
        throw new PulsarClientException("Failed to create TLS context, the tlsEnabledWithKeyStore need to be true");
    }

    private Supplier<SslContext> getSslContextSupplier(String host) {
        return this.sslContextSupplierMap.computeIfAbsent(host, key -> new ObjectCache<SslContext>(() -> {
            try {
                AuthenticationDataProvider authData;
                SslProvider sslProvider = null;
                if (this.conf.getSslProvider() != null) {
                    sslProvider = SslProvider.valueOf(this.conf.getSslProvider());
                }
                if ((authData = this.conf.getAuthentication().getAuthData(host)).hasDataForTls()) {
                    return authData.getTlsTrustStoreStream() == null ? SecurityUtility.createNettySslContextForClient(sslProvider, this.conf.isTlsAllowInsecureConnection(), this.conf.getTlsTrustCertsFilePath(), authData.getTlsCertificates(), authData.getTlsPrivateKey(), this.conf.getTlsCiphers(), this.conf.getTlsProtocols()) : SecurityUtility.createNettySslContextForClient(sslProvider, this.conf.isTlsAllowInsecureConnection(), authData.getTlsTrustStoreStream(), authData.getTlsCertificates(), authData.getTlsPrivateKey(), this.conf.getTlsCiphers(), this.conf.getTlsProtocols());
                }
                return SecurityUtility.createNettySslContextForClient(sslProvider, this.conf.isTlsAllowInsecureConnection(), this.conf.getTlsTrustCertsFilePath(), this.conf.getTlsCertificateFilePath(), this.conf.getTlsKeyFilePath(), this.conf.getTlsCiphers(), this.conf.getTlsProtocols());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create TLS context", e);
            }
        }, TLS_CERTIFICATE_CACHE_MILLIS, TimeUnit.MILLISECONDS));
    }

    CompletableFuture<Channel> initTls(Channel ch, InetSocketAddress sniHost) {
        Objects.requireNonNull(ch, "A channel is required");
        Objects.requireNonNull(sniHost, "A sniHost is required");
        if (!this.tlsEnabled) {
            throw new IllegalStateException("TLS is not enabled in client configuration");
        }
        CompletableFuture<Channel> initTlsFuture = new CompletableFuture<Channel>();
        ch.eventLoop().execute(() -> {
            try {
                SslHandler handler;
                SslHandler sslHandler = handler = this.tlsEnabledWithKeyStore ? new SslHandler(((KeyStoreSSLContext)this.getNettySSLContextAutoRefreshBuilder(sniHost.getHostName()).get()).createSSLEngine(sniHost.getHostString(), sniHost.getPort())) : this.getSslContextSupplier(sniHost.getHostName()).get().newHandler(ch.alloc(), sniHost.getHostString(), sniHost.getPort());
                if (this.tlsHostnameVerificationEnabled) {
                    SecurityUtility.configureSSLHandler(handler);
                }
                ch.pipeline().addFirst(TLS_HANDLER, (ChannelHandler)handler);
                initTlsFuture.complete(ch);
            }
            catch (Throwable t2) {
                initTlsFuture.completeExceptionally(t2);
            }
        });
        return initTlsFuture;
    }

    CompletableFuture<Channel> initSocks5IfConfig(Channel ch) {
        CompletableFuture<Channel> initSocks5Future = new CompletableFuture<Channel>();
        if (this.socks5ProxyAddress != null) {
            ch.eventLoop().execute(() -> {
                try {
                    Socks5ProxyHandler socks5ProxyHandler = new Socks5ProxyHandler(this.socks5ProxyAddress, this.socks5ProxyUsername, this.socks5ProxyPassword);
                    ch.pipeline().addFirst(socks5ProxyHandler.protocol(), (ChannelHandler)socks5ProxyHandler);
                    initSocks5Future.complete(ch);
                }
                catch (Throwable t2) {
                    initSocks5Future.completeExceptionally(t2);
                }
            });
        } else {
            initSocks5Future.complete(ch);
        }
        return initSocks5Future;
    }

    CompletableFuture<Channel> initializeClientCnx(Channel ch, InetSocketAddress logicalAddress, InetSocketAddress unresolvedPhysicalAddress) {
        return NettyFutureUtil.toCompletableFuture(ch.eventLoop().submit(() -> {
            ClientCnx cnx = (ClientCnx)ch.pipeline().get("handler");
            if (cnx == null) {
                throw new IllegalStateException("Missing ClientCnx. This should not happen.");
            }
            if (!logicalAddress.equals(unresolvedPhysicalAddress)) {
                cnx.setTargetBroker(logicalAddress);
            }
            cnx.setRemoteHostName(unresolvedPhysicalAddress.getHostString());
            return ch;
        }));
    }

    @Generated
    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }
}

