/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.client.manager.impl;

import com.alibaba.nacos.api.common.Constants;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.core.remote.ClientConnectionEventListener;
import com.alibaba.nacos.core.remote.Connection;
import com.alibaba.nacos.naming.core.v2.client.Client;
import com.alibaba.nacos.naming.core.v2.client.ClientAttributes;
import com.alibaba.nacos.naming.core.v2.client.factory.ClientFactory;
import com.alibaba.nacos.naming.core.v2.client.factory.ClientFactoryHolder;
import com.alibaba.nacos.naming.core.v2.client.impl.ConnectionBasedClient;
import com.alibaba.nacos.naming.core.v2.client.manager.ClientManager;
import com.alibaba.nacos.naming.core.v2.event.client.ClientEvent;
import com.alibaba.nacos.naming.misc.GlobalExecutor;
import com.alibaba.nacos.naming.misc.Loggers;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Component;

@Component(value="connectionBasedClientManager")
public class ConnectionBasedClientManager
extends ClientConnectionEventListener
implements ClientManager {
    private final ConcurrentMap<String, ConnectionBasedClient> clients = new ConcurrentHashMap<String, ConnectionBasedClient>();

    public ConnectionBasedClientManager() {
        GlobalExecutor.scheduleExpiredClientCleaner(new ExpiredClientCleaner(this), 0L, Constants.DEFAULT_HEART_BEAT_INTERVAL, TimeUnit.MILLISECONDS);
    }

    public void clientConnected(Connection connect) {
        if (!"naming".equals(connect.getMetaInfo().getLabel("module"))) {
            return;
        }
        ClientAttributes attributes = new ClientAttributes();
        attributes.addClientAttribute("connectionType", connect.getMetaInfo().getConnectType());
        attributes.addClientAttribute("connectionMetadata", connect.getMetaInfo());
        this.clientConnected(connect.getMetaInfo().getConnectionId(), attributes);
    }

    @Override
    public boolean clientConnected(String clientId, ClientAttributes attributes) {
        String type = (String)attributes.getClientAttribute("connectionType");
        ClientFactory clientFactory = ClientFactoryHolder.getInstance().findClientFactory(type);
        return this.clientConnected((Client)clientFactory.newClient(clientId, attributes));
    }

    @Override
    public boolean clientConnected(Client client) {
        this.clients.computeIfAbsent(client.getClientId(), s -> {
            Loggers.SRV_LOG.info("Client connection {} connect", (Object)client.getClientId());
            return (ConnectionBasedClient)client;
        });
        return true;
    }

    @Override
    public boolean syncClientConnected(String clientId, ClientAttributes attributes) {
        String type = (String)attributes.getClientAttribute("connectionType");
        ClientFactory clientFactory = ClientFactoryHolder.getInstance().findClientFactory(type);
        return this.clientConnected((Client)clientFactory.newSyncedClient(clientId, attributes));
    }

    public void clientDisConnected(Connection connect) {
        this.clientDisconnected(connect.getMetaInfo().getConnectionId());
    }

    @Override
    public boolean clientDisconnected(String clientId) {
        Loggers.SRV_LOG.info("Client connection {} disconnect, remove instances and subscribers", (Object)clientId);
        ConnectionBasedClient client = (ConnectionBasedClient)this.clients.remove(clientId);
        if (null == client) {
            return true;
        }
        client.release();
        NotifyCenter.publishEvent((Event)new ClientEvent.ClientDisconnectEvent(client));
        return true;
    }

    @Override
    public Client getClient(String clientId) {
        return (Client)this.clients.get(clientId);
    }

    @Override
    public boolean contains(String clientId) {
        return this.clients.containsKey(clientId);
    }

    @Override
    public Collection<String> allClientId() {
        return this.clients.keySet();
    }

    @Override
    public boolean isResponsibleClient(Client client) {
        return client instanceof ConnectionBasedClient && ((ConnectionBasedClient)client).isNative();
    }

    @Override
    public boolean verifyClient(String clientId) {
        ConnectionBasedClient client = (ConnectionBasedClient)this.clients.get(clientId);
        if (null != client) {
            client.setLastRenewTime();
            return true;
        }
        return false;
    }

    private static class ExpiredClientCleaner
    implements Runnable {
        private final ConnectionBasedClientManager clientManager;

        public ExpiredClientCleaner(ConnectionBasedClientManager clientManager) {
            this.clientManager = clientManager;
        }

        @Override
        public void run() {
            long currentTime = System.currentTimeMillis();
            for (String each : this.clientManager.allClientId()) {
                ConnectionBasedClient client = (ConnectionBasedClient)this.clientManager.getClient(each);
                if (null == client || !client.isExpire(currentTime)) continue;
                this.clientManager.clientDisconnected(each);
            }
        }
    }
}

