/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.consistency.persistent;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.utils.ConcurrentHashSet;
import com.alibaba.nacos.consistency.DataOperation;
import com.alibaba.nacos.naming.consistency.KeyBuilder;
import com.alibaba.nacos.naming.consistency.RecordListener;
import com.alibaba.nacos.naming.consistency.ValueChangeEvent;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.pojo.Record;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public final class PersistentNotifier
extends Subscriber<ValueChangeEvent> {
    private final Map<String, ConcurrentHashSet<RecordListener>> listenerMap = new ConcurrentHashMap<String, ConcurrentHashSet<RecordListener>>(32);
    private final Function<String, Record> find;

    public PersistentNotifier(Function<String, Record> find) {
        this.find = find;
    }

    public void registerListener(String key, RecordListener listener) {
        this.listenerMap.computeIfAbsent(key, s -> new ConcurrentHashSet());
        this.listenerMap.get(key).add((Object)listener);
    }

    public void deregisterListener(String key, RecordListener listener) {
        if (!this.listenerMap.containsKey(key)) {
            return;
        }
        this.listenerMap.get(key).remove((Object)listener);
    }

    public void deregisterAllListener(String key) {
        this.listenerMap.remove(key);
    }

    public Map<String, ConcurrentHashSet<RecordListener>> getListeners() {
        return this.listenerMap;
    }

    public <T extends Record> void notify(String key, DataOperation action, T value) {
        if (this.listenerMap.containsKey("com.alibaba.nacos.naming.domains.meta.") && KeyBuilder.matchServiceMetaKey(key) && !KeyBuilder.matchSwitchKey(key)) {
            for (RecordListener listener : this.listenerMap.get("com.alibaba.nacos.naming.domains.meta.")) {
                try {
                    if (action == DataOperation.CHANGE) {
                        listener.onChange(key, value);
                    }
                    if (action != DataOperation.DELETE) continue;
                    listener.onDelete(key);
                }
                catch (Throwable e) {
                    Loggers.RAFT.error("[NACOS-RAFT] error while notifying listener of key: {}", (Object)key, (Object)e);
                }
            }
        }
        if (!this.listenerMap.containsKey(key)) {
            return;
        }
        for (RecordListener listener : this.listenerMap.get(key)) {
            try {
                if (action == DataOperation.CHANGE) {
                    listener.onChange(key, value);
                    continue;
                }
                if (action != DataOperation.DELETE) continue;
                listener.onDelete(key);
            }
            catch (Throwable e) {
                Loggers.RAFT.error("[NACOS-RAFT] error while notifying listener of key: {}", (Object)key, (Object)e);
            }
        }
    }

    public void onEvent(ValueChangeEvent event) {
        this.notify(event.getKey(), event.getAction(), this.find.apply(event.getKey()));
    }

    public Class<? extends Event> subscribeType() {
        return ValueChangeEvent.class;
    }
}

