/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.consistency.persistent;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.common.utils.VersionUtils;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.naming.misc.GlobalExecutor;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.springframework.stereotype.Component;

@Component
public class ClusterVersionJudgement {
    private volatile boolean allMemberIsNewVersion = false;
    private final ServerMemberManager memberManager;
    private final List<ConsumerWithPriority> observers = new CopyOnWriteArrayList<ConsumerWithPriority>();

    public ClusterVersionJudgement(ServerMemberManager memberManager) {
        this.memberManager = memberManager;
        GlobalExecutor.submitClusterVersionJudge(this::runVersionListener, TimeUnit.SECONDS.toMillis(5L));
    }

    public void registerObserver(Consumer<Boolean> observer, int priority) {
        this.observers.add(new ConsumerWithPriority(observer, priority));
    }

    protected void runVersionListener() {
        if (EnvUtil.getStandaloneMode() || !EnvUtil.isSupportUpgradeFrom1X()) {
            this.notifyAllListener();
            return;
        }
        boolean finish = false;
        try {
            finish = this.judge();
        }
        finally {
            if (!finish) {
                GlobalExecutor.submitClusterVersionJudge(this::runVersionListener, TimeUnit.SECONDS.toMillis(5L));
            }
        }
    }

    protected boolean judge() {
        boolean finish = false;
        Collection members = this.memberManager.allMembers();
        String oldVersion = "1.4.0";
        boolean allMemberIsNewVersion = true;
        for (Member member : members) {
            String curV = (String)member.getExtendVal("version");
            if (!StringUtils.isBlank((CharSequence)curV) && VersionUtils.compareVersion((String)"1.4.0", (String)curV) <= 0) continue;
            allMemberIsNewVersion = false;
        }
        if (allMemberIsNewVersion && !this.allMemberIsNewVersion) {
            this.notifyAllListener();
            finish = true;
        }
        return finish;
    }

    private void notifyAllListener() {
        this.allMemberIsNewVersion = true;
        Collections.sort(this.observers);
        for (ConsumerWithPriority consumer : this.observers) {
            consumer.consumer.accept(true);
        }
    }

    public boolean allMemberIsNewVersion() {
        return this.allMemberIsNewVersion;
    }

    public void reset() {
        this.allMemberIsNewVersion = false;
    }

    private static class ConsumerWithPriority
    implements Comparable<ConsumerWithPriority> {
        private final Consumer<Boolean> consumer;
        private final int priority;

        public ConsumerWithPriority(Consumer<Boolean> consumer, int priority) {
            this.consumer = consumer;
            this.priority = priority;
        }

        @Override
        public int compareTo(ConsumerWithPriority o) {
            return o.priority - this.priority;
        }
    }
}

