/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.env;

import com.alibaba.nacos.client.env.AbstractPropertySource;
import com.alibaba.nacos.client.env.SourceType;
import com.alibaba.nacos.common.utils.ResourceUtils;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultSettingPropertySource
extends AbstractPropertySource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSettingPropertySource.class);
    private static final String DEFAULT_SETTING_PATH = "classpath:nacos_default_setting.properties";
    private final Properties defaultSetting = new Properties();

    DefaultSettingPropertySource() {
        try {
            URL resourceUrl = ResourceUtils.getResourceUrl((String)DEFAULT_SETTING_PATH);
            InputStream inputStream = resourceUrl.openStream();
            this.defaultSetting.load(inputStream);
        }
        catch (Exception e) {
            LOGGER.warn("load default setting failed");
        }
    }

    @Override
    SourceType getType() {
        return SourceType.DEFAULT_SETTING;
    }

    @Override
    String getProperty(String key) {
        return this.defaultSetting.getProperty(key);
    }
}

