/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle;

import com.puppycrawl.tools.checkstyle.ModuleFactory;
import com.puppycrawl.tools.checkstyle.TreeWalkerAuditEvent;
import com.puppycrawl.tools.checkstyle.TreeWalkerFilter;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.util.Set;

class FilteredModuleFactory
implements ModuleFactory {
    static final TreeWalkerFilter FILTERED = new TreeWalkerFilter(){

        public boolean accept(TreeWalkerAuditEvent treeWalkerAuditEvent) {
            return true;
        }
    };
    private final ModuleFactory moduleFactory;
    private final Set<String> excludes;

    FilteredModuleFactory(ModuleFactory moduleFactory, Set<String> excludes) {
        this.moduleFactory = moduleFactory;
        this.excludes = excludes;
    }

    public Object createModule(String name) throws CheckstyleException {
        Object module = this.moduleFactory.createModule(name);
        if (this.isFiltered(module)) {
            if (module instanceof AbstractCheck) {
                return FILTERED;
            }
            throw new IllegalStateException("Unable to filter module " + module.getClass().getName());
        }
        return module;
    }

    boolean nonFiltered(Configuration configuration) {
        return !this.isFiltered(configuration.getName());
    }

    private boolean isFiltered(Object module) {
        return this.isFiltered(module.getClass().getName());
    }

    private boolean isFiltered(String name) {
        return this.excludes != null && this.excludes.contains(name);
    }
}

