/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.api.spring;

import com.netflix.spinnaker.kork.annotations.Alpha;
import com.netflix.spinnaker.kork.plugins.api.spring.PrivilegedSpringPlugin;
import com.netflix.spinnaker.kork.plugins.api.spring.SpringLoader;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.pf4j.PluginWrapper;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

@Alpha
public abstract class SpringLoaderPlugin
extends PrivilegedSpringPlugin {
    protected AnnotationConfigApplicationContext pluginContext = new AnnotationConfigApplicationContext();

    public SpringLoaderPlugin(PluginWrapper wrapper) {
        super(wrapper);
    }

    @Override
    public void registerBeanDefinitions(BeanDefinitionRegistry registry) {
        String springLoaderBeanName = this.wrapper.getPluginId() + "." + SpringLoader.class.getName();
        ClassLoader pluginClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        AbstractBeanDefinition springLoaderBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition(SpringLoader.class).setScope("singleton").setAutowireMode(0).addConstructorArgValue((Object)this.pluginContext).addConstructorArgValue((Object)pluginClassLoader).addConstructorArgValue(this.getPackagesToScan()).addConstructorArgValue(this.getClassesToRegister()).getBeanDefinition();
        registry.registerBeanDefinition(springLoaderBeanName, (BeanDefinition)springLoaderBeanDefinition);
        BeanDefinition requestMappingHandlerMapping = registry.getBeanDefinition("requestMappingHandlerMapping");
        String[] mappingDependsOnArray = requestMappingHandlerMapping.getDependsOn();
        ArrayList<Object> mappingDependsOn = mappingDependsOnArray == null ? new ArrayList<CallSite>() : new ArrayList<String>(Arrays.asList(mappingDependsOnArray));
        mappingDependsOn.add(springLoaderBeanName);
        requestMappingHandlerMapping.setDependsOn(mappingDependsOn.toArray(new String[mappingDependsOn.size()]));
    }

    public List<String> getPackagesToScan() {
        return Collections.emptyList();
    }

    public List<Class> getClassesToRegister() {
        return Collections.emptyList();
    }
}

