package io.smallrye.stork.loadbalancer.random;

import io.smallrye.stork.loadbalancer.random.RandomConfiguration;
import io.smallrye.stork.loadbalancer.random.RandomLoadBalancerProvider;
import io.smallrye.stork.api.LoadBalancer;
import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.api.ServiceDiscovery;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.context.ApplicationScoped;

/**
 * LoadBalancerLoader for io.smallrye.stork.loadbalancer.random.RandomLoadBalancerProvider
 */
 @ApplicationScoped
 public class RandomLoadBalancerProviderLoader implements io.smallrye.stork.spi.internal.LoadBalancerLoader {
   private final io.smallrye.stork.loadbalancer.random.RandomLoadBalancerProvider provider;
   public RandomLoadBalancerProviderLoader() {
       io.smallrye.stork.loadbalancer.random.RandomLoadBalancerProvider actual = null;
       try {
          actual = CDI.current().select(io.smallrye.stork.loadbalancer.random.RandomLoadBalancerProvider.class).get();
       } catch(Exception e) { 
          // Use direct instantiation
          actual = new io.smallrye.stork.loadbalancer.random.RandomLoadBalancerProvider();
       } 
       this.provider = actual;
   }

   @Override
   public LoadBalancer createLoadBalancer(ConfigWithType config, ServiceDiscovery serviceDiscovery) {
      io.smallrye.stork.loadbalancer.random.RandomConfiguration typedConfig = new io.smallrye.stork.loadbalancer.random.RandomConfiguration(config.parameters());
      return provider.createLoadBalancer(typedConfig, serviceDiscovery);
   }

  /**
   * @return the type
   */
   @Override
   public String type() {
      return "random";
   }
}
