/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.loadbalancer.requests;

import io.smallrye.stork.api.LoadBalancer;
import io.smallrye.stork.api.NoAcceptableServiceInstanceFoundException;
import io.smallrye.stork.api.NoServiceInstanceFoundException;
import io.smallrye.stork.api.ServiceInstance;
import io.smallrye.stork.impl.ServiceInstanceWithStatGathering;
import io.smallrye.stork.loadbalancer.requests.InflightRequestCollector;
import io.smallrye.stork.spi.CallStatisticsCollector;
import java.util.Collection;

public class LeastRequestsLoadBalancer
implements LoadBalancer {
    private final InflightRequestCollector collector = new InflightRequestCollector();

    public ServiceInstance selectServiceInstance(Collection<ServiceInstance> serviceInstances) {
        if (serviceInstances.isEmpty()) {
            throw new NoServiceInstanceFoundException("No service instance found");
        }
        ServiceInstance selected = null;
        int min = Integer.MAX_VALUE;
        for (ServiceInstance instance : serviceInstances) {
            int concurrency = this.collector.get(instance.getId());
            if (concurrency >= min) continue;
            selected = instance;
            min = concurrency;
        }
        if (selected == null) {
            throw new NoAcceptableServiceInstanceFoundException("No service instance found");
        }
        return new ServiceInstanceWithStatGathering(selected, (CallStatisticsCollector)this.collector);
    }
}

