/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.loadbalancer.requests;

import io.smallrye.stork.spi.CallStatisticsCollector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class InflightRequestCollector
implements CallStatisticsCollector {
    private final ConcurrentHashMap<Long, AtomicInteger> storage = new ConcurrentHashMap();

    public int get(long id) {
        return this.storage.computeIfAbsent(id, x -> new AtomicInteger(0)).get();
    }

    public void recordStart(long serviceInstanceId, boolean measureTime) {
        this.storage.get(serviceInstanceId).incrementAndGet();
    }

    public void recordEnd(long serviceInstanceId, Throwable throwable) {
        this.storage.get(serviceInstanceId).decrementAndGet();
    }
}

