package io.smallrye.stork.loadbalancer.requests;

import io.smallrye.stork.loadbalancer.requests.LeastRequestsConfiguration;
import io.smallrye.stork.loadbalancer.requests.LeastRequestsLoadBalancerProvider;
import io.smallrye.stork.api.LoadBalancer;
import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.api.ServiceDiscovery;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.context.ApplicationScoped;

/**
 * LoadBalancerLoader for io.smallrye.stork.loadbalancer.requests.LeastRequestsLoadBalancerProvider
 */
 @ApplicationScoped
 public class LeastRequestsLoadBalancerProviderLoader implements io.smallrye.stork.spi.internal.LoadBalancerLoader {
   private final io.smallrye.stork.loadbalancer.requests.LeastRequestsLoadBalancerProvider provider;
   public LeastRequestsLoadBalancerProviderLoader() {
       io.smallrye.stork.loadbalancer.requests.LeastRequestsLoadBalancerProvider actual = null;
       try {
          actual = CDI.current().select(io.smallrye.stork.loadbalancer.requests.LeastRequestsLoadBalancerProvider.class).get();
       } catch(Exception e) { 
          // Use direct instantiation
          actual = new io.smallrye.stork.loadbalancer.requests.LeastRequestsLoadBalancerProvider();
       } 
       this.provider = actual;
   }

   @Override
   public LoadBalancer createLoadBalancer(ConfigWithType config, ServiceDiscovery serviceDiscovery) {
      io.smallrye.stork.loadbalancer.requests.LeastRequestsConfiguration typedConfig = new io.smallrye.stork.loadbalancer.requests.LeastRequestsConfiguration(config.parameters());
      return provider.createLoadBalancer(typedConfig, serviceDiscovery);
   }

  /**
   * @return the type
   */
   @Override
   public String type() {
      return "least-requests";
   }
}
