package io.smallrye.stork.loadbalancer.requests;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import io.smallrye.stork.api.config.ConfigWithType;

/**
 *  Configuration for the {@code LeastRequestsLoadBalancerProvider} LoadBalancer.
 */
 public class LeastRequestsConfiguration implements io.smallrye.stork.api.config.ConfigWithType{
   private final Map<String, String> parameters;

   /**
    * Creates a new LeastRequestsConfiguration
    *
    * @param params the parameters, must not be {@code null}
    */
   public LeastRequestsConfiguration(Map<String, String> params) {
      parameters = Collections.unmodifiableMap(params);
   }

   /**
    * Creates a new LeastRequestsConfiguration
    */
   public LeastRequestsConfiguration() {
      parameters = Collections.emptyMap();
   }


  /**
   * @return the type
   */
   @Override
   public String type() {
      return "least-requests";
   }


   /**
    * @return the parameters
    */
   @Override
   public Map<String, String> parameters() {
      return parameters;
   }

   private LeastRequestsConfiguration extend(String key, String value) {
      Map<String, String> copy = new HashMap<>(parameters);
      copy.put(key, value);
      return new LeastRequestsConfiguration(copy);
   }
}
