/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics;

import io.smallrye.metrics.MetricsRegistryImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.RegistryType;

@ApplicationScoped
public class MetricRegistries {
    private static final Map<MetricRegistry.Type, MetricRegistry> registries = new ConcurrentHashMap<MetricRegistry.Type, MetricRegistry>();

    @Produces
    @Default
    @RegistryType(type=MetricRegistry.Type.APPLICATION)
    @ApplicationScoped
    public MetricRegistry getApplicationRegistry() {
        return MetricRegistries.get(MetricRegistry.Type.APPLICATION);
    }

    @Produces
    @RegistryType(type=MetricRegistry.Type.BASE)
    @ApplicationScoped
    public MetricRegistry getBaseRegistry() {
        return MetricRegistries.get(MetricRegistry.Type.BASE);
    }

    @Produces
    @RegistryType(type=MetricRegistry.Type.VENDOR)
    @ApplicationScoped
    public MetricRegistry getVendorRegistry() {
        return MetricRegistries.get(MetricRegistry.Type.VENDOR);
    }

    public static MetricRegistry get(MetricRegistry.Type type) {
        return registries.computeIfAbsent(type, t -> new MetricsRegistryImpl());
    }

    @PreDestroy
    public void cleanUp() {
        registries.remove(MetricRegistry.Type.APPLICATION);
    }

    public static void drop(MetricRegistry.Type type) {
        registries.remove(type);
    }

    public static void dropAll() {
        registries.remove(MetricRegistry.Type.APPLICATION);
        registries.remove(MetricRegistry.Type.BASE);
        registries.remove(MetricRegistry.Type.VENDOR);
    }
}

