/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution;

import graphql.ExecutionResult;
import io.smallrye.graphql.execution.error.ExecutionErrorsService;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonValue;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import jakarta.json.spi.JsonProvider;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExecutionResponse {
    private static final JsonProvider jsonProvider = JsonProvider.provider();
    private static final JsonBuilderFactory jsonObjectFactory = Json.createBuilderFactory(null);
    private static final JsonReaderFactory jsonReaderFactory = Json.createReaderFactory(null);
    private static final Jsonb jsonB = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withNullValues(Boolean.TRUE).withFormatting(Boolean.TRUE));
    private static final ExecutionErrorsService errorsService = new ExecutionErrorsService();
    private final ExecutionResult executionResult;
    private Map<String, Object> addedExtensions;
    private static final String DATA = "data";
    private static final String ERRORS = "errors";
    private static final String EXTENSIONS = "extensions";

    public ExecutionResponse(ExecutionResult executionResult) {
        this(executionResult, null);
    }

    public ExecutionResponse(ExecutionResult executionResult, Map<String, Object> addedExtensions) {
        this.executionResult = executionResult;
        this.addedExtensions = addedExtensions;
    }

    public String toString() {
        return "ExecutionResponse->" + this.executionResult;
    }

    public ExecutionResult getExecutionResult() {
        return this.executionResult;
    }

    public JsonObject getExecutionResultAsJsonObject() {
        JsonObjectBuilder returnObjectBuilder = jsonObjectFactory.createObjectBuilder();
        returnObjectBuilder = this.addErrorsToResponse(returnObjectBuilder, this.executionResult);
        returnObjectBuilder = this.addDataToResponse(returnObjectBuilder, this.executionResult);
        returnObjectBuilder = this.addExtensionsToResponse(returnObjectBuilder, this.executionResult);
        return returnObjectBuilder.build();
    }

    public String getExecutionResultAsString() {
        return this.getExecutionResultAsJsonObject().toString();
    }

    private JsonObjectBuilder addErrorsToResponse(JsonObjectBuilder returnObjectBuilder, ExecutionResult executionResult) {
        JsonArray jsonArray;
        List errors = executionResult.getErrors();
        if (errors != null && !(jsonArray = errorsService.toJsonErrors(errors)).isEmpty()) {
            returnObjectBuilder = returnObjectBuilder.add(ERRORS, (JsonValue)jsonArray);
        }
        return returnObjectBuilder;
    }

    private JsonObjectBuilder addDataToResponse(JsonObjectBuilder returnObjectBuilder, ExecutionResult executionResult) {
        Object pojoData = executionResult.getData();
        return this.addDataToResponse(returnObjectBuilder, pojoData);
    }

    private JsonObjectBuilder addDataToResponse(JsonObjectBuilder returnObjectBuilder, Object pojoData) {
        if (pojoData != null) {
            JsonValue data = this.toJsonValue(pojoData);
            return returnObjectBuilder.add(DATA, data);
        }
        return returnObjectBuilder.addNull(DATA);
    }

    private JsonObjectBuilder addExtensionsToResponse(JsonObjectBuilder returnObjectBuilder, ExecutionResult executionResult) {
        Map extensions = executionResult.getExtensions();
        if (extensions != null) {
            returnObjectBuilder = this.addExtensionToBuilder(extensions, returnObjectBuilder);
        } else if (this.addedExtensions != null && !this.addedExtensions.isEmpty()) {
            returnObjectBuilder = this.addExtensionToBuilder(new HashMap<Object, Object>(this.addedExtensions), returnObjectBuilder);
        }
        return returnObjectBuilder;
    }

    private JsonObjectBuilder addExtensionToBuilder(Map<Object, Object> extensions, JsonObjectBuilder returnObjectBuilder) {
        JsonObject extensionsObject = this.buildExtensions(extensions);
        return returnObjectBuilder.add(EXTENSIONS, (JsonValue)extensionsObject);
    }

    private JsonObject buildExtensions(Map<Object, Object> extensions) {
        JsonObjectBuilder extensionsBuilder = jsonObjectFactory.createObjectBuilder();
        for (Map.Entry<Object, Object> entry : extensions.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            String key = (String)entry.getKey();
            JsonValue value = this.toJsonValue(entry.getValue());
            extensionsBuilder.add(key, value);
        }
        return extensionsBuilder.build();
    }

    private JsonValue toJsonValue(Object pojo) {
        JsonValue jsonValue;
        if (pojo == null) {
            return JsonValue.NULL;
        }
        if (pojo instanceof Map) {
            JsonObjectBuilder jsonObjectBuilder = jsonObjectFactory.createObjectBuilder();
            Map map = (Map)pojo;
            for (Map.Entry stringObjectEntry : map.entrySet()) {
                jsonObjectBuilder.add((String)stringObjectEntry.getKey(), this.toJsonValue(stringObjectEntry.getValue()));
            }
            jsonValue = jsonObjectBuilder.build();
        } else if (pojo instanceof Collection) {
            Collection map = (Collection)pojo;
            JsonArrayBuilder builder = jsonObjectFactory.createArrayBuilder();
            for (Object o : map) {
                builder.add(this.toJsonValue(o));
            }
            jsonValue = builder.build();
        } else if (pojo instanceof Boolean) {
            jsonValue = ((Boolean)pojo).booleanValue() ? JsonValue.TRUE : JsonValue.FALSE;
        } else if (pojo instanceof String) {
            jsonValue = jsonProvider.createValue((String)pojo);
        } else if (pojo instanceof Double) {
            jsonValue = jsonProvider.createValue(((Number)pojo).doubleValue());
        } else if (pojo instanceof Float) {
            jsonValue = jsonProvider.createValue(new BigDecimal(String.valueOf(((Number)pojo).floatValue())));
        } else if (pojo instanceof Long) {
            jsonValue = jsonProvider.createValue((Number)((Long)pojo));
        } else if (pojo instanceof Integer || pojo instanceof Short || pojo instanceof Byte) {
            jsonValue = jsonProvider.createValue(((Number)pojo).intValue());
        } else if (pojo instanceof BigDecimal) {
            jsonValue = jsonProvider.createValue((BigDecimal)pojo);
        } else if (pojo instanceof BigInteger) {
            jsonValue = jsonProvider.createValue((BigInteger)pojo);
        } else if (pojo instanceof Enum) {
            jsonValue = jsonProvider.createValue(((Enum)pojo).name());
        } else {
            String json = jsonB.toJson(pojo);
            try (StringReader sr = new StringReader(json);
                 JsonReader reader = jsonReaderFactory.createReader((Reader)sr);){
                jsonValue = reader.readValue();
            }
        }
        return jsonValue;
    }
}

