/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.helpers;

import io.smallrye.common.annotation.Identifier;
import io.smallrye.reactive.messaging.providers.i18n.ProviderLogging;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.literal.NamedLiteral;
import jakarta.enterprise.inject.spi.Prioritized;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class CDIUtils {
    public static <T extends Prioritized> List<T> getSortedInstances(Instance<T> instances) {
        if (instances == null || instances.isUnsatisfied()) {
            return Collections.emptyList();
        }
        return instances.stream().sorted(Comparator.comparingInt(Prioritized::getPriority)).collect(Collectors.toList());
    }

    public static <T> Instance<T> getInstanceById(Instance<T> instances, String identifier) {
        Instance matching = instances.select(new Annotation[]{Identifier.Literal.of((String)identifier)});
        if (matching.isUnsatisfied() && !(matching = instances.select(new Annotation[]{NamedLiteral.of((String)identifier)})).isUnsatisfied()) {
            ProviderLogging.log.deprecatedNamed();
        }
        return matching;
    }

    public static <T> T getInstanceById(Instance<T> instances, String identifier, Supplier<T> defaultSupplier) {
        Instance<T> instanceById = CDIUtils.getInstanceById(instances, identifier);
        if (instanceById.isUnsatisfied()) {
            return defaultSupplier.get();
        }
        return (T)instanceById.get();
    }
}

