/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.extension;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.unchecked.Unchecked;
import io.smallrye.reactive.messaging.ChannelRegistry;
import io.smallrye.reactive.messaging.PublisherDecorator;
import io.smallrye.reactive.messaging.observation.MessageObservation;
import io.smallrye.reactive.messaging.observation.MessageObservationCollector;
import io.smallrye.reactive.messaging.observation.ObservationContext;
import io.smallrye.reactive.messaging.providers.ProcessingException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Optional;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Metadata;

@ApplicationScoped
public class ObservationDecorator
implements PublisherDecorator {
    @Inject
    @ConfigProperty(name="smallrye.messaging.observation.enabled", defaultValue="true")
    boolean enabled;
    @Inject
    ChannelRegistry registry;
    @Inject
    Instance<MessageObservationCollector<?>> observationCollector;

    public Multi<? extends Message<?>> decorate(Multi<? extends Message<?>> multi, List<String> channelName, boolean isConnector) {
        String channel = channelName.isEmpty() ? null : channelName.get(0);
        boolean isEmitter = this.registry.getEmitterNames().contains(channel);
        if (this.observationCollector.isResolvable() && this.enabled && (isConnector || isEmitter)) {
            return ObservationDecorator.decorateObservation((MessageObservationCollector<? extends ObservationContext>)((MessageObservationCollector)this.observationCollector.get()), multi, channel, !isEmitter, isEmitter);
        }
        return multi;
    }

    static Multi<? extends Message<?>> decorateObservation(MessageObservationCollector<? extends ObservationContext> obsCollector, Multi<? extends Message<?>> multi, String channel, boolean incoming, boolean emitter) {
        MessageObservationCollector<? extends ObservationContext> collector = obsCollector;
        ObservationContext context = collector.initObservation(channel, incoming, emitter);
        if (context == null) {
            return multi;
        }
        return multi.map(message -> {
            MessageObservation observation = collector.onNewMessage(channel, message, context);
            if (observation != null) {
                return message.addMetadata((Object)observation).thenApply(msg -> msg.withAckWithMetadata(metadata -> msg.ack(metadata).thenAccept(Unchecked.consumer(x -> ObservationDecorator.getObservationMetadata(metadata).ifPresent(obs -> {
                    obs.onMessageAck(msg);
                    context.complete(obs);
                }))))).thenApply(msg -> msg.withNackWithMetadata((reason, metadata) -> {
                    ObservationDecorator.getObservationMetadata(metadata).ifPresent(Unchecked.consumer(obs -> {
                        obs.onMessageNack(msg, ObservationDecorator.extractReason(reason));
                        context.complete(obs);
                    }));
                    return msg.nack(reason, metadata);
                }));
            }
            return message;
        });
    }

    static Optional<MessageObservation> getObservationMetadata(Metadata metadata) {
        for (Object item : metadata) {
            if (!(item instanceof MessageObservation)) continue;
            return Optional.of((MessageObservation)item);
        }
        return Optional.empty();
    }

    static Throwable extractReason(Throwable reason) {
        if (reason instanceof ProcessingException) {
            Throwable cause = reason.getCause();
            if (cause instanceof InvocationTargetException) {
                cause = ((InvocationTargetException)cause).getTargetException();
            }
            return cause;
        }
        return reason;
    }
}

