package io.vertx.mutiny.servicediscovery.types;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.servicediscovery.spi.ServiceType;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;
import java.util.function.Function;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.servicediscovery.types.MongoDataSource original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.servicediscovery.types.MongoDataSource.class)
public class MongoDataSource {

  public static final io.smallrye.mutiny.vertx.TypeArg<MongoDataSource> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MongoDataSource((io.vertx.servicediscovery.types.MongoDataSource) obj),
    MongoDataSource::getDelegate
  );

  private final io.vertx.servicediscovery.types.MongoDataSource delegate;
  
  public MongoDataSource(io.vertx.servicediscovery.types.MongoDataSource delegate) {
    this.delegate = delegate;
  }

  public MongoDataSource(Object delegate) {
    this.delegate = (io.vertx.servicediscovery.types.MongoDataSource)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MongoDataSource() {
    this.delegate = null;
  }

  public io.vertx.servicediscovery.types.MongoDataSource getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MongoDataSource that = (MongoDataSource) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param name the service name
   * @param location the location of the service (e.g. url, port...)
   * @param metadata additional metadata
   * @return the created record
   */
  public static io.vertx.servicediscovery.Record createRecord(String name, JsonObject location, JsonObject metadata) { 
    io.vertx.servicediscovery.Record ret = io.vertx.servicediscovery.types.MongoDataSource.createRecord(name, location, metadata);
    return ret;
  }

  /**
   * Convenient method that looks for a Mongo datasource source and provides the configured {@link io.vertx.mutiny.ext.mongo.MongoClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.mongo.MongoClient> getMongoClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        io.vertx.servicediscovery.types.MongoDataSource.getMongoClient(discovery.getDelegate(), filter, new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.ext.mongo.MongoClient.newInstance((io.vertx.ext.mongo.MongoClient)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.types.MongoDataSource#getMongoClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @return the MongoClient instance produced by the operation.
   */
  public static io.vertx.mutiny.ext.mongo.MongoClient getMongoClientAndAwait(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter) { 
    return (io.vertx.mutiny.ext.mongo.MongoClient) getMongoClient(discovery, filter).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.types.MongoDataSource#getMongoClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.types.MongoDataSource#getMongoClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.types.MongoDataSource#getMongoClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject)} but you don't need to compose it with other operations.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   */
  public static void getMongoClientAndForget(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter) { 
    getMongoClient(discovery, filter).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Convenient method that looks for a Mongo datasource source and provides the configured
   * {@link io.vertx.mutiny.ext.mongo.MongoClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param discovery The service discovery instance
   * @param filter The filter
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.mongo.MongoClient> getMongoClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        io.vertx.servicediscovery.types.MongoDataSource.getMongoClient(discovery.getDelegate(), filter, new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.ext.mongo.MongoClient.newInstance((io.vertx.ext.mongo.MongoClient)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.types.MongoDataSource#getMongoClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param discovery The service discovery instance
   * @param filter The filter
   * @return the MongoClient instance produced by the operation.
   */
  public static io.vertx.mutiny.ext.mongo.MongoClient getMongoClientAndAwait(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter) { 
    return (io.vertx.mutiny.ext.mongo.MongoClient) getMongoClient(discovery, filter).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.types.MongoDataSource#getMongoClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.types.MongoDataSource#getMongoClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.types.MongoDataSource#getMongoClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function)} but you don't need to compose it with other operations.
   * @param discovery The service discovery instance
   * @param filter The filter
   */
  public static void getMongoClientAndForget(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter) { 
    getMongoClient(discovery, filter).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Convenient method that looks for a Mongo datasource source and provides the configured {@link io.vertx.mutiny.ext.mongo.MongoClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param consumerConfiguration the consumer configuration
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.mongo.MongoClient> getMongoClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter, JsonObject consumerConfiguration) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        io.vertx.servicediscovery.types.MongoDataSource.getMongoClient(discovery.getDelegate(), filter, consumerConfiguration, new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.ext.mongo.MongoClient.newInstance((io.vertx.ext.mongo.MongoClient)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.types.MongoDataSource#getMongoClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param consumerConfiguration the consumer configuration
   * @return the MongoClient instance produced by the operation.
   */
  public static io.vertx.mutiny.ext.mongo.MongoClient getMongoClientAndAwait(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter, JsonObject consumerConfiguration) { 
    return (io.vertx.mutiny.ext.mongo.MongoClient) getMongoClient(discovery, filter, consumerConfiguration).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.types.MongoDataSource#getMongoClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.types.MongoDataSource#getMongoClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.types.MongoDataSource#getMongoClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject,JsonObject)} but you don't need to compose it with other operations.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param consumerConfiguration the consumer configuration
   */
  public static void getMongoClientAndForget(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter, JsonObject consumerConfiguration) { 
    getMongoClient(discovery, filter, consumerConfiguration).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Unknown type.
   */
  public static final String UNKNOWN = io.vertx.servicediscovery.types.MongoDataSource.UNKNOWN;
  public static final String TYPE = io.vertx.servicediscovery.types.MongoDataSource.TYPE;
  public static  MongoDataSource newInstance(io.vertx.servicediscovery.types.MongoDataSource arg) {
    return arg != null ? new MongoDataSource(arg) : null;
  }

}
