package io.vertx.mutiny.servicediscovery.types;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.servicediscovery.spi.ServiceType;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;
import java.util.function.Function;

/**
 * Service type for data producer. Providers are publishing data to a specific event bus address.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.servicediscovery.types.MessageSource original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.servicediscovery.types.MessageSource.class)
public class MessageSource {

  public static final io.smallrye.mutiny.vertx.TypeArg<MessageSource> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MessageSource((io.vertx.servicediscovery.types.MessageSource) obj),
    MessageSource::getDelegate
  );

  private final io.vertx.servicediscovery.types.MessageSource delegate;
  
  public MessageSource(io.vertx.servicediscovery.types.MessageSource delegate) {
    this.delegate = delegate;
  }

  public MessageSource(Object delegate) {
    this.delegate = (io.vertx.servicediscovery.types.MessageSource)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MessageSource() {
    this.delegate = null;
  }

  public io.vertx.servicediscovery.types.MessageSource getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MessageSource that = (MessageSource) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param name the name of the service
   * @param address the address on which the data is sent
   * @param type the type of payload (fully qualified name of the class)
   * @param metadata additional metadata
   * @return the created record
   */
  public static io.vertx.servicediscovery.Record createRecord(String name, String address, String type, JsonObject metadata) { 
    io.vertx.servicediscovery.Record ret = io.vertx.servicediscovery.types.MessageSource.createRecord(name, address, type, metadata);
    return ret;
  }

  /**
   * @param name the name of the service
   * @param address the address on which the data is sent
   * @param type the type of payload
   * @return the created record
   */
  public static io.vertx.servicediscovery.Record createRecord(String name, String address, String type) { 
    io.vertx.servicediscovery.Record ret = io.vertx.servicediscovery.types.MessageSource.createRecord(name, address, type);
    return ret;
  }

  /**
   * @param name the name of the service
   * @param address the address on which the data is sent.
   * @return the created record
   */
  public static io.vertx.servicediscovery.Record createRecord(String name, String address) { 
    io.vertx.servicediscovery.Record ret = io.vertx.servicediscovery.types.MessageSource.createRecord(name, address);
    return ret;
  }

  /**
   * Convenient method that looks for a message source and provides the configured . The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static <T> io.smallrye.mutiny.Uni<io.vertx.mutiny.core.eventbus.MessageConsumer<T>> getConsumer(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        io.vertx.servicediscovery.types.MessageSource.getConsumer(discovery.getDelegate(), filter, new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.core.eventbus.MessageConsumer.newInstance((io.vertx.core.eventbus.MessageConsumer)event, TypeArg.unknown()))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.types.MessageSource#getConsumer(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @return the MessageConsumer<T> instance produced by the operation.
   */
  public static <T> io.vertx.mutiny.core.eventbus.MessageConsumer<T> getConsumerAndAwait(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter) { 
    return (io.vertx.mutiny.core.eventbus.MessageConsumer<T>) getConsumer(discovery, filter).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.types.MessageSource#getConsumer(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.types.MessageSource#getConsumer(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.types.MessageSource#getConsumer(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject)} but you don't need to compose it with other operations.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   */
  public static <T> void getConsumerAndForget(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter) { 
    getConsumer(discovery, filter).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Convenient method that looks for a message source and provides the configured . The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param discovery The service discovery instance
   * @param filter The filter, must not be <code>null</code>
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static <T> io.smallrye.mutiny.Uni<io.vertx.mutiny.core.eventbus.MessageConsumer<T>> getConsumer(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        io.vertx.servicediscovery.types.MessageSource.getConsumer(discovery.getDelegate(), filter, new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.core.eventbus.MessageConsumer.newInstance((io.vertx.core.eventbus.MessageConsumer)event, TypeArg.unknown()))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.types.MessageSource#getConsumer(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param discovery The service discovery instance
   * @param filter The filter, must not be <code>null</code>
   * @return the MessageConsumer<T> instance produced by the operation.
   */
  public static <T> io.vertx.mutiny.core.eventbus.MessageConsumer<T> getConsumerAndAwait(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter) { 
    return (io.vertx.mutiny.core.eventbus.MessageConsumer<T>) getConsumer(discovery, filter).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.types.MessageSource#getConsumer(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.types.MessageSource#getConsumer(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.types.MessageSource#getConsumer(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function)} but you don't need to compose it with other operations.
   * @param discovery The service discovery instance
   * @param filter The filter, must not be <code>null</code>
   */
  public static <T> void getConsumerAndForget(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter) { 
    getConsumer(discovery, filter).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Unknown type.
   */
  public static final String UNKNOWN = io.vertx.servicediscovery.types.MessageSource.UNKNOWN;
  public static final String TYPE = io.vertx.servicediscovery.types.MessageSource.TYPE;
  public static  MessageSource newInstance(io.vertx.servicediscovery.types.MessageSource arg) {
    return arg != null ? new MessageSource(arg) : null;
  }

}
