package io.vertx.mutiny.servicediscovery.types;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.servicediscovery.spi.ServiceType;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;
import java.util.function.Function;

/**
 *  for HTTP endpoint (REST api).
 * Consumers receive a HTTP client configured with the host and port of the endpoint.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.servicediscovery.types.HttpEndpoint original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.servicediscovery.types.HttpEndpoint.class)
public class HttpEndpoint {

  public static final io.smallrye.mutiny.vertx.TypeArg<HttpEndpoint> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new HttpEndpoint((io.vertx.servicediscovery.types.HttpEndpoint) obj),
    HttpEndpoint::getDelegate
  );

  private final io.vertx.servicediscovery.types.HttpEndpoint delegate;
  
  public HttpEndpoint(io.vertx.servicediscovery.types.HttpEndpoint delegate) {
    this.delegate = delegate;
  }

  public HttpEndpoint(Object delegate) {
    this.delegate = (io.vertx.servicediscovery.types.HttpEndpoint)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  HttpEndpoint() {
    this.delegate = null;
  }

  public io.vertx.servicediscovery.types.HttpEndpoint getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpEndpoint that = (HttpEndpoint) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param name the service name
   * @param host the host (IP or DNS name), it must be the _public_ IP / name
   * @param port the port, it must be the _public_ port
   * @param root the path of the service, "/" if not set
   * @param metadata additional metadata
   * @return the created record
   */
  public static io.vertx.servicediscovery.Record createRecord(String name, String host, int port, String root, JsonObject metadata) { 
    io.vertx.servicediscovery.Record ret = io.vertx.servicediscovery.types.HttpEndpoint.createRecord(name, host, port, root, metadata);
    return ret;
  }

  /**
   * @param name the service name
   * @param ssl whether or not the service is using HTTPS
   * @param host the host (IP or DNS name), it must be the _public_ IP / name
   * @param port the port, it must be the _public_ port
   * @param root the path of the service, "/" if not set
   * @param metadata additional metadata
   * @return the created record
   */
  public static io.vertx.servicediscovery.Record createRecord(String name, boolean ssl, String host, int port, String root, JsonObject metadata) { 
    io.vertx.servicediscovery.Record ret = io.vertx.servicediscovery.types.HttpEndpoint.createRecord(name, ssl, host, port, root, metadata);
    return ret;
  }

  /**
   * @param name the service name
   * @param host the host, must be public
   * @param port the port
   * @param root the root, if not set "/" is used
   * @return the created record
   */
  public static io.vertx.servicediscovery.Record createRecord(String name, String host, int port, String root) { 
    io.vertx.servicediscovery.Record ret = io.vertx.servicediscovery.types.HttpEndpoint.createRecord(name, host, port, root);
    return ret;
  }

  /**
   * @param name the name
   * @param host the host
   * @return the created record
   */
  public static io.vertx.servicediscovery.Record createRecord(String name, String host) { 
    io.vertx.servicediscovery.Record ret = io.vertx.servicediscovery.types.HttpEndpoint.createRecord(name, host);
    return ret;
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.core.http.HttpClient> getClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        io.vertx.servicediscovery.types.HttpEndpoint.getClient(discovery.getDelegate(), filter, new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.core.http.HttpClient.newInstance((io.vertx.core.http.HttpClient)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @return the HttpClient instance produced by the operation.
   */
  public static io.vertx.mutiny.core.http.HttpClient getClientAndAwait(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter) { 
    return (io.vertx.mutiny.core.http.HttpClient) getClient(discovery, filter).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject)} but you don't need to compose it with other operations.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   */
  public static void getClientAndForget(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter) { 
    getClient(discovery, filter).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.web.client.WebClient> getWebClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        io.vertx.servicediscovery.types.HttpEndpoint.getWebClient(discovery.getDelegate(), filter, new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.ext.web.client.WebClient.newInstance((io.vertx.ext.web.client.WebClient)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getWebClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @return the WebClient instance produced by the operation.
   */
  public static io.vertx.mutiny.ext.web.client.WebClient getWebClientAndAwait(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter) { 
    return (io.vertx.mutiny.ext.web.client.WebClient) getWebClient(discovery, filter).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getWebClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getWebClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getWebClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject)} but you don't need to compose it with other operations.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   */
  public static void getWebClientAndForget(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter) { 
    getWebClient(discovery, filter).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails. This method accepts a
   * configuration for the HTTP client
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param conf the configuration of the client
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.core.http.HttpClient> getClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter, JsonObject conf) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        io.vertx.servicediscovery.types.HttpEndpoint.getClient(discovery.getDelegate(), filter, conf, new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.core.http.HttpClient.newInstance((io.vertx.core.http.HttpClient)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param conf the configuration of the client
   * @return the HttpClient instance produced by the operation.
   */
  public static io.vertx.mutiny.core.http.HttpClient getClientAndAwait(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter, JsonObject conf) { 
    return (io.vertx.mutiny.core.http.HttpClient) getClient(discovery, filter, conf).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject,JsonObject)} but you don't need to compose it with other operations.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param conf the configuration of the client
   */
  public static void getClientAndForget(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter, JsonObject conf) { 
    getClient(discovery, filter, conf).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails. This method accepts a
   * configuration for the HTTP client
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param conf the configuration of the client
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.web.client.WebClient> getWebClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter, JsonObject conf) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        io.vertx.servicediscovery.types.HttpEndpoint.getWebClient(discovery.getDelegate(), filter, conf, new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.ext.web.client.WebClient.newInstance((io.vertx.ext.web.client.WebClient)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getWebClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param conf the configuration of the client
   * @return the WebClient instance produced by the operation.
   */
  public static io.vertx.mutiny.ext.web.client.WebClient getWebClientAndAwait(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter, JsonObject conf) { 
    return (io.vertx.mutiny.ext.web.client.WebClient) getWebClient(discovery, filter, conf).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getWebClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getWebClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getWebClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,JsonObject,JsonObject)} but you don't need to compose it with other operations.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param conf the configuration of the client
   */
  public static void getWebClientAndForget(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, JsonObject filter, JsonObject conf) { 
    getWebClient(discovery, filter, conf).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param discovery The service discovery instance
   * @param filter The filter
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.core.http.HttpClient> getClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        io.vertx.servicediscovery.types.HttpEndpoint.getClient(discovery.getDelegate(), filter, new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.core.http.HttpClient.newInstance((io.vertx.core.http.HttpClient)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param discovery The service discovery instance
   * @param filter The filter
   * @return the HttpClient instance produced by the operation.
   */
  public static io.vertx.mutiny.core.http.HttpClient getClientAndAwait(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter) { 
    return (io.vertx.mutiny.core.http.HttpClient) getClient(discovery, filter).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function)} but you don't need to compose it with other operations.
   * @param discovery The service discovery instance
   * @param filter The filter
   */
  public static void getClientAndForget(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter) { 
    getClient(discovery, filter).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param discovery The service discovery instance
   * @param filter The filter
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.web.client.WebClient> getWebClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        io.vertx.servicediscovery.types.HttpEndpoint.getWebClient(discovery.getDelegate(), filter, new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.ext.web.client.WebClient.newInstance((io.vertx.ext.web.client.WebClient)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getWebClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param discovery The service discovery instance
   * @param filter The filter
   * @return the WebClient instance produced by the operation.
   */
  public static io.vertx.mutiny.ext.web.client.WebClient getWebClientAndAwait(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter) { 
    return (io.vertx.mutiny.ext.web.client.WebClient) getWebClient(discovery, filter).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getWebClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getWebClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getWebClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function)} but you don't need to compose it with other operations.
   * @param discovery The service discovery instance
   * @param filter The filter
   */
  public static void getWebClientAndForget(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter) { 
    getWebClient(discovery, filter).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails. This method accepts a
   * configuration for the HTTP client.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param discovery The service discovery instance
   * @param filter The filter
   * @param conf the configuration of the client
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.core.http.HttpClient> getClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, JsonObject conf) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        io.vertx.servicediscovery.types.HttpEndpoint.getClient(discovery.getDelegate(), filter, conf, new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.core.http.HttpClient.newInstance((io.vertx.core.http.HttpClient)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param discovery The service discovery instance
   * @param filter The filter
   * @param conf the configuration of the client
   * @return the HttpClient instance produced by the operation.
   */
  public static io.vertx.mutiny.core.http.HttpClient getClientAndAwait(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, JsonObject conf) { 
    return (io.vertx.mutiny.core.http.HttpClient) getClient(discovery, filter, conf).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function,JsonObject)} but you don't need to compose it with other operations.
   * @param discovery The service discovery instance
   * @param filter The filter
   * @param conf the configuration of the client
   */
  public static void getClientAndForget(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, JsonObject conf) { 
    getClient(discovery, filter, conf).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Convenient method that looks for a HTTP endpoint and provides the configured . The async result
   * is marked as failed is there are no matching services, or if the lookup fails. This method accepts a
   * configuration for the HTTP client.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param discovery The service discovery instance
   * @param filter The filter
   * @param conf the configuration of the client
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.ext.web.client.WebClient> getWebClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, JsonObject conf) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        io.vertx.servicediscovery.types.HttpEndpoint.getWebClient(discovery.getDelegate(), filter, conf, new io.smallrye.mutiny.vertx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.mutiny.ext.web.client.WebClient.newInstance((io.vertx.ext.web.client.WebClient)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getWebClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function,JsonObject)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param discovery The service discovery instance
   * @param filter The filter
   * @param conf the configuration of the client
   * @return the WebClient instance produced by the operation.
   */
  public static io.vertx.mutiny.ext.web.client.WebClient getWebClientAndAwait(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, JsonObject conf) { 
    return (io.vertx.mutiny.ext.web.client.WebClient) getWebClient(discovery, filter, conf).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getWebClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function,JsonObject)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getWebClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function,JsonObject)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.servicediscovery.types.HttpEndpoint#getWebClient(io.vertx.mutiny.servicediscovery.ServiceDiscovery,Function,JsonObject)} but you don't need to compose it with other operations.
   * @param discovery The service discovery instance
   * @param filter The filter
   * @param conf the configuration of the client
   */
  public static void getWebClientAndForget(io.vertx.mutiny.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, JsonObject conf) { 
    getWebClient(discovery, filter, conf).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Unknown type.
   */
  public static final String UNKNOWN = io.vertx.servicediscovery.types.HttpEndpoint.UNKNOWN;
  public static final String TYPE = io.vertx.servicediscovery.types.HttpEndpoint.TYPE;
  public static  HttpEndpoint newInstance(io.vertx.servicediscovery.types.HttpEndpoint arg) {
    return arg != null ? new HttpEndpoint(arg) : null;
  }

}
