package io.vertx.mutiny.servicediscovery.spi;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.json.JsonObject;
import io.vertx.core.Handler;

/**
 * The service importer allows integrate other discovery technologies with the Vert.x service discovery. It maps
 * entries from another technology to a  and maps  to a publication in this other
 * technology. The importer is one side of a service discovery bridge.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.servicediscovery.spi.ServiceImporter original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.servicediscovery.spi.ServiceImporter.class)
public class ServiceImporter {

  public static final io.smallrye.mutiny.vertx.TypeArg<ServiceImporter> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new ServiceImporter((io.vertx.servicediscovery.spi.ServiceImporter) obj),
    ServiceImporter::getDelegate
  );

  private final io.vertx.servicediscovery.spi.ServiceImporter delegate;
  
  public ServiceImporter(io.vertx.servicediscovery.spi.ServiceImporter delegate) {
    this.delegate = delegate;
  }

  public ServiceImporter(Object delegate) {
    this.delegate = (io.vertx.servicediscovery.spi.ServiceImporter)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  ServiceImporter() {
    this.delegate = null;
  }

  public io.vertx.servicediscovery.spi.ServiceImporter getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServiceImporter that = (ServiceImporter) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx the vertx instance
   * @param publisher the service publisher instance
   * @param configuration the bridge configuration if any
   * @param future a future on which the bridge must report the completion of the starting
   */
  public void start(io.vertx.mutiny.core.Vertx vertx, io.vertx.mutiny.servicediscovery.spi.ServicePublisher publisher, JsonObject configuration, io.vertx.mutiny.core.Promise<Void> future) { 
    delegate.start(vertx.getDelegate(), publisher.getDelegate(), configuration, future.getDelegate());
  }

  /**
   * @param closeHandler the handle to be notified when importer is closed, may be <code>null</code>
   */
  private void __close(Handler<Void> closeHandler) { 
    delegate.close(closeHandler);
  }

  /**
   * @param closeHandler the handle to be notified when importer is closed, may be <code>null</code>
   */
  public void close(java.lang.Runnable closeHandler) {
    __close(ignored -> closeHandler.run()
);
  }

  public static  ServiceImporter newInstance(io.vertx.servicediscovery.spi.ServiceImporter arg) {
    return arg != null ? new ServiceImporter(arg) : null;
  }

}
