package io.vertx.mutiny.servicediscovery.spi;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.core.Handler;

/**
 * The service exporter allows integrate other discovery technologies with the Vert.x service discovery. It maps
 * entries from another technology to a  and maps  to a publication in this other
 * technology. The exporter is one side of a service discovery bridge.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.servicediscovery.spi.ServiceExporter original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.servicediscovery.spi.ServiceExporter.class)
public class ServiceExporter {

  public static final io.smallrye.mutiny.vertx.TypeArg<ServiceExporter> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new ServiceExporter((io.vertx.servicediscovery.spi.ServiceExporter) obj),
    ServiceExporter::getDelegate
  );

  private final io.vertx.servicediscovery.spi.ServiceExporter delegate;
  
  public ServiceExporter(io.vertx.servicediscovery.spi.ServiceExporter delegate) {
    this.delegate = delegate;
  }

  public ServiceExporter(Object delegate) {
    this.delegate = (io.vertx.servicediscovery.spi.ServiceExporter)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  ServiceExporter() {
    this.delegate = null;
  }

  public io.vertx.servicediscovery.spi.ServiceExporter getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServiceExporter that = (ServiceExporter) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx the vertx instance
   * @param publisher the service discovery instance
   * @param configuration the bridge configuration if any
   * @param future a future on which the bridge must report the completion of the starting
   */
  public void init(io.vertx.mutiny.core.Vertx vertx, io.vertx.mutiny.servicediscovery.spi.ServicePublisher publisher, JsonObject configuration, io.vertx.mutiny.core.Promise<Void> future) { 
    delegate.init(vertx.getDelegate(), publisher.getDelegate(), configuration, future.getDelegate());
  }

  /**
   * @param record the record
   */
  public void onPublish(io.vertx.servicediscovery.Record record) { 
    delegate.onPublish(record);
  }

  /**
   * @param record the record
   */
  public void onUpdate(io.vertx.servicediscovery.Record record) { 
    delegate.onUpdate(record);
  }

  /**
   * @param id the record registration id
   */
  public void onUnpublish(String id) { 
    delegate.onUnpublish(id);
  }

  /**
   * @param closeHandler the handle to be notified when exporter is closed, may be <code>null</code>
   */
  private void __close(Handler<Void> closeHandler) { 
    delegate.close(closeHandler);
  }

  /**
   * @param closeHandler the handle to be notified when exporter is closed, may be <code>null</code>
   */
  public void close(java.lang.Runnable closeHandler) {
    __close(ignored -> closeHandler.run()
);
  }

  public static  ServiceExporter newInstance(io.vertx.servicediscovery.spi.ServiceExporter arg) {
    return arg != null ? new ServiceExporter(arg) : null;
  }

}
