/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.ext.mail;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyDelegate;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Vertx;
import io.vertx.ext.mail.MailConfig;
import io.vertx.ext.mail.MailMessage;
import io.vertx.ext.mail.MailResult;

@MutinyGen(value=io.vertx.ext.mail.MailClient.class)
public class MailClient
implements MutinyDelegate {
    public static final TypeArg<MailClient> __TYPE_ARG = new TypeArg(obj -> new MailClient((io.vertx.ext.mail.MailClient)obj), MailClient::getDelegate);
    private final io.vertx.ext.mail.MailClient delegate;
    public static final String DEFAULT_POOL_NAME = "DEFAULT_POOL";

    public MailClient(io.vertx.ext.mail.MailClient delegate) {
        this.delegate = delegate;
    }

    public MailClient(Object delegate) {
        this.delegate = (io.vertx.ext.mail.MailClient)delegate;
    }

    MailClient() {
        this.delegate = null;
    }

    public io.vertx.ext.mail.MailClient getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MailClient that = (MailClient)o;
        return this.delegate.equals((Object)that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static MailClient create(io.vertx.mutiny.core.Vertx vertx, MailConfig config) {
        MailClient ret = MailClient.newInstance(io.vertx.ext.mail.MailClient.create((Vertx)vertx.getDelegate(), (MailConfig)config));
        return ret;
    }

    public static MailClient createShared(io.vertx.mutiny.core.Vertx vertx, MailConfig config, String poolName) {
        MailClient ret = MailClient.newInstance(io.vertx.ext.mail.MailClient.createShared((Vertx)vertx.getDelegate(), (MailConfig)config, (String)poolName));
        return ret;
    }

    public static MailClient createShared(io.vertx.mutiny.core.Vertx vertx, MailConfig config) {
        MailClient ret = MailClient.newInstance(io.vertx.ext.mail.MailClient.createShared((Vertx)vertx.getDelegate(), (MailConfig)config));
        return ret;
    }

    @CheckReturnValue
    public Uni<MailResult> sendMail(MailMessage email) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.sendMail(email, resultHandler));
    }

    public MailResult sendMailAndAwait(MailMessage email) {
        return (MailResult)this.sendMail(email).await().indefinitely();
    }

    @Fluent
    public MailClient sendMailAndForget(MailMessage email) {
        this.sendMail(email).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> close() {
        return AsyncResultUni.toUni(closedHandler -> this.delegate.close(closedHandler));
    }

    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    public void closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
    }

    public static MailClient newInstance(io.vertx.ext.mail.MailClient arg) {
        return arg != null ? new MailClient(arg) : null;
    }
}

