/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.circuitbreaker;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.circuitbreaker.CircuitBreakerOptions;
import io.vertx.circuitbreaker.CircuitBreakerState;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.mutiny.circuitbreaker.RetryPolicy;
import io.vertx.mutiny.core.Promise;
import java.util.function.Function;

@MutinyGen(value=io.vertx.circuitbreaker.CircuitBreaker.class)
public class CircuitBreaker {
    public static final TypeArg<CircuitBreaker> __TYPE_ARG = new TypeArg(obj -> new CircuitBreaker((io.vertx.circuitbreaker.CircuitBreaker)obj), CircuitBreaker::getDelegate);
    private final io.vertx.circuitbreaker.CircuitBreaker delegate;
    private String cached_0;

    public CircuitBreaker(io.vertx.circuitbreaker.CircuitBreaker delegate) {
        this.delegate = delegate;
    }

    public CircuitBreaker(Object delegate) {
        this.delegate = (io.vertx.circuitbreaker.CircuitBreaker)delegate;
    }

    CircuitBreaker() {
        this.delegate = null;
    }

    public io.vertx.circuitbreaker.CircuitBreaker getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CircuitBreaker that = (CircuitBreaker)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static CircuitBreaker create(String name, io.vertx.mutiny.core.Vertx vertx, CircuitBreakerOptions options) {
        CircuitBreaker ret = CircuitBreaker.newInstance(io.vertx.circuitbreaker.CircuitBreaker.create((String)name, (Vertx)vertx.getDelegate(), (CircuitBreakerOptions)options));
        return ret;
    }

    public static CircuitBreaker create(String name, io.vertx.mutiny.core.Vertx vertx) {
        CircuitBreaker ret = CircuitBreaker.newInstance(io.vertx.circuitbreaker.CircuitBreaker.create((String)name, (Vertx)vertx.getDelegate()));
        return ret;
    }

    @Fluent
    public CircuitBreaker close() {
        this.delegate.close();
        return this;
    }

    @Fluent
    private CircuitBreaker __openHandler(Handler<Void> handler) {
        this.delegate.openHandler(handler);
        return this;
    }

    public CircuitBreaker openHandler(Runnable handler) {
        return this.__openHandler((Handler<Void>)((Handler)ignored -> handler.run()));
    }

    @Fluent
    private CircuitBreaker __halfOpenHandler(Handler<Void> handler) {
        this.delegate.halfOpenHandler(handler);
        return this;
    }

    public CircuitBreaker halfOpenHandler(Runnable handler) {
        return this.__halfOpenHandler((Handler<Void>)((Handler)ignored -> handler.run()));
    }

    @Fluent
    private CircuitBreaker __closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public CircuitBreaker closeHandler(Runnable handler) {
        return this.__closeHandler((Handler<Void>)((Handler)ignored -> handler.run()));
    }

    @CheckReturnValue
    public <T> Uni<T> executeWithFallback(final Uni<T> command, Function<Throwable, T> fallback) {
        return AsyncResultUni.toUni(handler -> this.delegate.executeWithFallback(new Handler<io.vertx.core.Promise<T>>(){

            public void handle(io.vertx.core.Promise<T> event) {
                command.subscribe().with(it -> event.complete(it), failure -> event.fail(failure));
            }
        }, fallback, handler));
    }

    public <T> T executeWithFallbackAndAwait(Uni<T> command, Function<Throwable, T> fallback) {
        return (T)this.executeWithFallback(command, fallback).await().indefinitely();
    }

    public <T> void executeWithFallbackAndForget(Uni<T> command, Function<Throwable, T> fallback) {
        this.executeWithFallback(command, fallback).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public <T> Uni<T> execute(final Uni<T> command) {
        return AsyncResultUni.toUni(handler -> this.delegate.execute(new Handler<io.vertx.core.Promise<T>>(){

            public void handle(io.vertx.core.Promise<T> event) {
                command.subscribe().with(it -> event.complete(it), failure -> event.fail(failure));
            }
        }, handler));
    }

    public <T> T executeAndAwait(Uni<T> command) {
        return (T)this.execute(command).await().indefinitely();
    }

    public <T> void executeAndForget(Uni<T> command) {
        this.execute(command).subscribe().with(UniHelper.NOOP);
    }

    @Fluent
    private <T> CircuitBreaker __executeAndReport(Promise<T> resultPromise, final Uni<T> command) {
        this.delegate.executeAndReport(resultPromise.getDelegate(), new Handler<io.vertx.core.Promise<T>>(){

            public void handle(io.vertx.core.Promise<T> event) {
                command.subscribe().with(it -> event.complete(it), failure -> event.fail(failure));
            }
        });
        return this;
    }

    public <T> CircuitBreaker executeAndReport(Promise<T> resultPromise, Uni<T> command) {
        return this.__executeAndReport(resultPromise, command);
    }

    @Fluent
    public <T> CircuitBreaker executeAndReportWithFallback(Promise<T> resultPromise, final Uni<T> command, Function<Throwable, T> fallback) {
        this.delegate.executeAndReportWithFallback(resultPromise.getDelegate(), new Handler<io.vertx.core.Promise<T>>(){

            public void handle(io.vertx.core.Promise<T> event) {
                command.subscribe().with(it -> event.complete(it), failure -> event.fail(failure));
            }
        }, fallback);
        return this;
    }

    @Fluent
    public <T> CircuitBreaker fallback(Function<Throwable, T> handler) {
        this.delegate.fallback(handler);
        return this;
    }

    @Fluent
    public CircuitBreaker reset() {
        this.delegate.reset();
        return this;
    }

    @Fluent
    public CircuitBreaker open() {
        this.delegate.open();
        return this;
    }

    public CircuitBreakerState state() {
        CircuitBreakerState ret = this.delegate.state();
        return ret;
    }

    public long failureCount() {
        long ret = this.delegate.failureCount();
        return ret;
    }

    public String name() {
        String ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = this.delegate.name();
        return ret;
    }

    @Deprecated
    @Fluent
    public CircuitBreaker retryPolicy(Function<Integer, Long> retryPolicy) {
        this.delegate.retryPolicy(retryPolicy);
        return this;
    }

    @Fluent
    public CircuitBreaker retryPolicy(RetryPolicy retryPolicy) {
        this.delegate.retryPolicy(retryPolicy.getDelegate());
        return this;
    }

    public static CircuitBreaker newInstance(io.vertx.circuitbreaker.CircuitBreaker arg) {
        return arg != null ? new CircuitBreaker(arg) : null;
    }
}

