package io.vertx.mutiny.circuitbreaker;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * A policy for retry execution.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.circuitbreaker.RetryPolicy original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.circuitbreaker.RetryPolicy.class)
public class RetryPolicy {

  public static final io.smallrye.mutiny.vertx.TypeArg<RetryPolicy> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new RetryPolicy((io.vertx.circuitbreaker.RetryPolicy) obj),
    RetryPolicy::getDelegate
  );

  private final io.vertx.circuitbreaker.RetryPolicy delegate;
  
  public RetryPolicy(io.vertx.circuitbreaker.RetryPolicy delegate) {
    this.delegate = delegate;
  }

  public RetryPolicy(Object delegate) {
    this.delegate = (io.vertx.circuitbreaker.RetryPolicy)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  RetryPolicy() {
    this.delegate = null;
  }

  public io.vertx.circuitbreaker.RetryPolicy getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RetryPolicy that = (RetryPolicy) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param delay the constant delay in milliseconds
   * @return 
   */
  public static io.vertx.mutiny.circuitbreaker.RetryPolicy constantDelay(long delay) { 
    io.vertx.mutiny.circuitbreaker.RetryPolicy ret = io.vertx.mutiny.circuitbreaker.RetryPolicy.newInstance((io.vertx.circuitbreaker.RetryPolicy)io.vertx.circuitbreaker.RetryPolicy.constantDelay(delay));
    return ret;
  }

  /**
   * @param initialDelay the initial delay in milliseconds
   * @param maxDelay maximum delay in milliseconds
   * @return 
   */
  public static io.vertx.mutiny.circuitbreaker.RetryPolicy linearDelay(long initialDelay, long maxDelay) { 
    io.vertx.mutiny.circuitbreaker.RetryPolicy ret = io.vertx.mutiny.circuitbreaker.RetryPolicy.newInstance((io.vertx.circuitbreaker.RetryPolicy)io.vertx.circuitbreaker.RetryPolicy.linearDelay(initialDelay, maxDelay));
    return ret;
  }

  /**
   * @param initialDelay the initial delay in milliseconds
   * @param maxDelay maximum delay in milliseconds
   * @return 
   */
  public static io.vertx.mutiny.circuitbreaker.RetryPolicy exponentialDelayWithJitter(long initialDelay, long maxDelay) { 
    io.vertx.mutiny.circuitbreaker.RetryPolicy ret = io.vertx.mutiny.circuitbreaker.RetryPolicy.newInstance((io.vertx.circuitbreaker.RetryPolicy)io.vertx.circuitbreaker.RetryPolicy.exponentialDelayWithJitter(initialDelay, maxDelay));
    return ret;
  }

  /**
   * @param failure the failure passed to the operation {@link io.vertx.mutiny.core.Promise}
   * @param retryCount the number of times operation has been retried already
   * @return a delay in milliseconds before retry is executed
   */
  public long delay(java.lang.Throwable failure, int retryCount) { 
    long ret = delegate.delay(failure, retryCount);
    return ret;
  }

  public static  RetryPolicy newInstance(io.vertx.circuitbreaker.RetryPolicy arg) {
    return arg != null ? new RetryPolicy(arg) : null;
  }

}
