package io.vertx.mutiny.circuitbreaker;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Handler;

/**
 * A Vert.x web handler to expose the circuit breaker to the Hystrix dasbboard. The handler listens to the circuit
 * breaker notifications sent on the event bus.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.circuitbreaker.HystrixMetricHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.circuitbreaker.HystrixMetricHandler.class)
public class HystrixMetricHandler implements io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  public static final io.smallrye.mutiny.vertx.TypeArg<HystrixMetricHandler> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new HystrixMetricHandler((io.vertx.circuitbreaker.HystrixMetricHandler) obj),
    HystrixMetricHandler::getDelegate
  );

  private final io.vertx.circuitbreaker.HystrixMetricHandler delegate;
  
  public HystrixMetricHandler(io.vertx.circuitbreaker.HystrixMetricHandler delegate) {
    this.delegate = delegate;
  }

  public HystrixMetricHandler(Object delegate) {
    this.delegate = (io.vertx.circuitbreaker.HystrixMetricHandler)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  HystrixMetricHandler() {
    this.delegate = null;
  }

  public io.vertx.circuitbreaker.HystrixMetricHandler getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HystrixMetricHandler that = (HystrixMetricHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * @param vertx the Vert.x instance
   * @return the handler
   */
  public static io.vertx.mutiny.circuitbreaker.HystrixMetricHandler create(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.circuitbreaker.HystrixMetricHandler ret = io.vertx.mutiny.circuitbreaker.HystrixMetricHandler.newInstance((io.vertx.circuitbreaker.HystrixMetricHandler)io.vertx.circuitbreaker.HystrixMetricHandler.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param vertx the Vert.x instance
   * @param address the address to listen on the event bus
   * @return the handler
   */
  public static io.vertx.mutiny.circuitbreaker.HystrixMetricHandler create(io.vertx.mutiny.core.Vertx vertx, String address) { 
    io.vertx.mutiny.circuitbreaker.HystrixMetricHandler ret = io.vertx.mutiny.circuitbreaker.HystrixMetricHandler.newInstance((io.vertx.circuitbreaker.HystrixMetricHandler)io.vertx.circuitbreaker.HystrixMetricHandler.create(vertx.getDelegate(), address));
    return ret;
  }

  /**
   * @param vertx the Vert.x instance
   * @param address the address to listen on the event bus
   * @param localOnly whether the consumer should only receive messages sent from this Vert.x instance
   * @return the handler
   */
  public static io.vertx.mutiny.circuitbreaker.HystrixMetricHandler create(io.vertx.mutiny.core.Vertx vertx, String address, boolean localOnly) { 
    io.vertx.mutiny.circuitbreaker.HystrixMetricHandler ret = io.vertx.mutiny.circuitbreaker.HystrixMetricHandler.newInstance((io.vertx.circuitbreaker.HystrixMetricHandler)io.vertx.circuitbreaker.HystrixMetricHandler.create(vertx.getDelegate(), address, localOnly));
    return ret;
  }

  public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  HystrixMetricHandler newInstance(io.vertx.circuitbreaker.HystrixMetricHandler arg) {
    return arg != null ? new HystrixMetricHandler(arg) : null;
  }

}
