package io.vertx.mutiny.circuitbreaker;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.circuitbreaker.CircuitBreakerOptions;
import io.vertx.circuitbreaker.CircuitBreakerState;
import io.vertx.core.Future;
import java.util.function.Function;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * An implementation of the circuit breaker pattern for Vert.x
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.circuitbreaker.CircuitBreaker original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.circuitbreaker.CircuitBreaker.class)
public class CircuitBreaker {

  public static final io.smallrye.mutiny.vertx.TypeArg<CircuitBreaker> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new CircuitBreaker((io.vertx.circuitbreaker.CircuitBreaker) obj),
    CircuitBreaker::getDelegate
  );

  private final io.vertx.circuitbreaker.CircuitBreaker delegate;
  
  public CircuitBreaker(io.vertx.circuitbreaker.CircuitBreaker delegate) {
    this.delegate = delegate;
  }

  public CircuitBreaker(Object delegate) {
    this.delegate = (io.vertx.circuitbreaker.CircuitBreaker)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  CircuitBreaker() {
    this.delegate = null;
  }

  public io.vertx.circuitbreaker.CircuitBreaker getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CircuitBreaker that = (CircuitBreaker) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param name the name
   * @param vertx the Vert.x instance
   * @param options the configuration option
   * @return the created instance
   */
  public static io.vertx.mutiny.circuitbreaker.CircuitBreaker create(String name, io.vertx.mutiny.core.Vertx vertx, io.vertx.circuitbreaker.CircuitBreakerOptions options) { 
    io.vertx.mutiny.circuitbreaker.CircuitBreaker ret = io.vertx.mutiny.circuitbreaker.CircuitBreaker.newInstance((io.vertx.circuitbreaker.CircuitBreaker)io.vertx.circuitbreaker.CircuitBreaker.create(name, vertx.getDelegate(), options));
    return ret;
  }

  /**
   * @param name the name
   * @param vertx the Vert.x instance
   * @return the created instance
   */
  public static io.vertx.mutiny.circuitbreaker.CircuitBreaker create(String name, io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.circuitbreaker.CircuitBreaker ret = io.vertx.mutiny.circuitbreaker.CircuitBreaker.newInstance((io.vertx.circuitbreaker.CircuitBreaker)io.vertx.circuitbreaker.CircuitBreaker.create(name, vertx.getDelegate()));
    return ret;
  }

  /**
   * @return the instance of CircuitBreaker to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.circuitbreaker.CircuitBreaker close() { 
    delegate.close();
    return this;
  }

  /**
   * @param handler the handler, must not be <code>null</code>
   * @return the current {@link io.vertx.mutiny.circuitbreaker.CircuitBreaker}
   */
  @Fluent
  private io.vertx.mutiny.circuitbreaker.CircuitBreaker __openHandler(Handler<Void> handler) { 
    delegate.openHandler(handler);
    return this;
  }

  /**
   * @param handler the handler, must not be <code>null</code>
   * @return 
   */
  public io.vertx.mutiny.circuitbreaker.CircuitBreaker openHandler(java.lang.Runnable handler) {
    return __openHandler(ignored -> handler.run()
);
  }

  /**
   * @param handler the handler, must not be <code>null</code>
   * @return the current {@link io.vertx.mutiny.circuitbreaker.CircuitBreaker}
   */
  @Fluent
  private io.vertx.mutiny.circuitbreaker.CircuitBreaker __halfOpenHandler(Handler<Void> handler) { 
    delegate.halfOpenHandler(handler);
    return this;
  }

  /**
   * @param handler the handler, must not be <code>null</code>
   * @return 
   */
  public io.vertx.mutiny.circuitbreaker.CircuitBreaker halfOpenHandler(java.lang.Runnable handler) {
    return __halfOpenHandler(ignored -> handler.run()
);
  }

  /**
   * @param handler the handler, must not be <code>null</code>
   * @return the current {@link io.vertx.mutiny.circuitbreaker.CircuitBreaker}
   */
  @Fluent
  private io.vertx.mutiny.circuitbreaker.CircuitBreaker __closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * @param handler the handler, must not be <code>null</code>
   * @return 
   */
  public io.vertx.mutiny.circuitbreaker.CircuitBreaker closeHandler(java.lang.Runnable handler) {
    return __closeHandler(ignored -> handler.run()
);
  }

  /**
   * Same as {@link io.vertx.mutiny.circuitbreaker.CircuitBreaker#executeWithFallback} but using a callback.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param command the operation
   * @param fallback the fallback
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public <T> io.smallrye.mutiny.Uni<T> executeWithFallback(io.smallrye.mutiny.Uni<T> command, Function<java.lang.Throwable, T> fallback) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.executeWithFallback(new Handler<io.vertx.core.Promise<T>>() {
          public void handle(io.vertx.core.Promise<T> event) {
            command.subscribe().with(it -> event.complete(it), failure -> event.fail(failure));
          }
      }, fallback, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.circuitbreaker.CircuitBreaker#executeWithFallback(Consumer,Function)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param command the operation
   * @param fallback the fallback
   * @return the T instance produced by the operation.
   */
  public <T> T executeWithFallbackAndAwait(io.smallrye.mutiny.Uni<T> command, Function<java.lang.Throwable, T> fallback) { 
    return (T) executeWithFallback(command, fallback).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.circuitbreaker.CircuitBreaker#executeWithFallback(Consumer,Function)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.circuitbreaker.CircuitBreaker#executeWithFallback(Consumer,Function)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.circuitbreaker.CircuitBreaker#executeWithFallback(Consumer,Function)} but you don't need to compose it with other operations.
   * @param command the operation
   * @param fallback the fallback
   */
  public <T> void executeWithFallbackAndForget(io.smallrye.mutiny.Uni<T> command, Function<java.lang.Throwable, T> fallback) { 
    executeWithFallback(command, fallback).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Same as {@link io.vertx.mutiny.circuitbreaker.CircuitBreaker#executeWithFallback} but using the circuit breaker default fallback.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param command the operation
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public <T> io.smallrye.mutiny.Uni<T> execute(io.smallrye.mutiny.Uni<T> command) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.execute(new Handler<io.vertx.core.Promise<T>>() {
          public void handle(io.vertx.core.Promise<T> event) {
            command.subscribe().with(it -> event.complete(it), failure -> event.fail(failure));
          }
      }, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.circuitbreaker.CircuitBreaker#execute(Consumer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param command the operation
   * @return the T instance produced by the operation.
   */
  public <T> T executeAndAwait(io.smallrye.mutiny.Uni<T> command) { 
    return (T) execute(command).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.circuitbreaker.CircuitBreaker#execute(Consumer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.circuitbreaker.CircuitBreaker#execute(Consumer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.circuitbreaker.CircuitBreaker#execute(Consumer)} but you don't need to compose it with other operations.
   * @param command the operation
   */
  public <T> void executeAndForget(io.smallrye.mutiny.Uni<T> command) { 
    execute(command).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @param resultPromise the promise on which the operation result is reported
   * @param command the operation
   * @return the current {@link io.vertx.mutiny.circuitbreaker.CircuitBreaker}
   */
  @Fluent
  private <T> io.vertx.mutiny.circuitbreaker.CircuitBreaker __executeAndReport(io.vertx.mutiny.core.Promise<T> resultPromise, io.smallrye.mutiny.Uni<T> command) { 
    delegate.executeAndReport(resultPromise.getDelegate(), new Handler<io.vertx.core.Promise<T>>() {
          public void handle(io.vertx.core.Promise<T> event) {
            command.subscribe().with(it -> event.complete(it), failure -> event.fail(failure));
          }
      });
    return this;
  }

  /**
   * @param resultPromise the promise on which the operation result is reported
   * @param command the operation
   * @return 
   */
  public <T> io.vertx.mutiny.circuitbreaker.CircuitBreaker executeAndReport(io.vertx.mutiny.core.Promise<T> resultPromise, io.smallrye.mutiny.Uni<T> command) {
    return __executeAndReport(resultPromise, command);
  }

  /**
   * @param resultPromise the promise on which the operation result is reported
   * @param command the operation
   * @param fallback the fallback function. It gets an exception as parameter and returns the <em>fallback</em> result
   * @return the current {@link io.vertx.mutiny.circuitbreaker.CircuitBreaker}
   */
  @Fluent
  public <T> io.vertx.mutiny.circuitbreaker.CircuitBreaker executeAndReportWithFallback(io.vertx.mutiny.core.Promise<T> resultPromise, io.smallrye.mutiny.Uni<T> command, Function<java.lang.Throwable, T> fallback) { 
    delegate.executeAndReportWithFallback(resultPromise.getDelegate(), new Handler<io.vertx.core.Promise<T>>() {
          public void handle(io.vertx.core.Promise<T> event) {
            command.subscribe().with(it -> event.complete(it), failure -> event.fail(failure));
          }
      }, fallback);
    return this;
  }

  /**
   * @param handler the handler
   * @return the current {@link io.vertx.mutiny.circuitbreaker.CircuitBreaker}
   */
  @Fluent
  public <T> io.vertx.mutiny.circuitbreaker.CircuitBreaker fallback(Function<java.lang.Throwable, T> handler) { 
    delegate.fallback(handler);
    return this;
  }

  /**
   * @return the current {@link io.vertx.mutiny.circuitbreaker.CircuitBreaker}
   */
  @Fluent
  public io.vertx.mutiny.circuitbreaker.CircuitBreaker reset() { 
    delegate.reset();
    return this;
  }

  /**
   * @return the current {@link io.vertx.mutiny.circuitbreaker.CircuitBreaker}
   */
  @Fluent
  public io.vertx.mutiny.circuitbreaker.CircuitBreaker open() { 
    delegate.open();
    return this;
  }

  /**
   * @return the current state.
   */
  public io.vertx.circuitbreaker.CircuitBreakerState state() { 
    io.vertx.circuitbreaker.CircuitBreakerState ret = delegate.state();
    return ret;
  }

  /**
   * @return the current number of failures.
   */
  public long failureCount() { 
    long ret = delegate.failureCount();
    return ret;
  }

  /**
   * @return the name of the circuit breaker.
   */
  public String name() { 
    if (cached_0 != null) {
      return cached_0;
    }
    String ret = delegate.name();
    cached_0 = ret;
    return ret;
  }

  /**
   * @param retryPolicy 
   * @return the instance of CircuitBreaker to chain method calls.
   * @deprecated use {@link #retryPolicy(RetryPolicy)} instead   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.circuitbreaker.CircuitBreaker retryPolicy(Function<Integer, Long> retryPolicy) { 
    delegate.retryPolicy(retryPolicy);
    return this;
  }

  /**
   * @param retryPolicy 
   * @return the instance of CircuitBreaker to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.circuitbreaker.CircuitBreaker retryPolicy(io.vertx.mutiny.circuitbreaker.RetryPolicy retryPolicy) { 
    delegate.retryPolicy(retryPolicy.getDelegate());
    return this;
  }

  private String cached_0;
  public static  CircuitBreaker newInstance(io.vertx.circuitbreaker.CircuitBreaker arg) {
    return arg != null ? new CircuitBreaker(arg) : null;
  }

}
