/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.io;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.io.DeleteStats;
import io.smallrye.common.io.Messages;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SecureDirectoryStream;
import java.nio.file.attribute.BasicFileAttributeView;

public final class Files2 {
    private static final Path CWD;
    private static final SecureDirectoryStream<Path> CWD_SDS;

    private Files2() {
    }

    public static SecureDirectoryStream<Path> newSecureDirectoryStream(Path path, LinkOption ... linkOptions) throws IOException {
        Assert.checkNotNullParam((String)"path", (Object)path);
        Assert.checkNotNullParam((String)"linkOptions", (Object)linkOptions);
        SecureDirectoryStream<Path> base = CWD_SDS;
        if (base == null) {
            throw Messages.log.secureDirectoryNotSupported(path.getFileSystem(), path);
        }
        return base.newDirectoryStream(path, linkOptions);
    }

    public static void deleteRecursivelyEvenIfInsecure(Path path) throws IOException {
        Assert.checkNotNullParam((String)"path", (Object)path);
        SecureDirectoryStream<Path> base = CWD_SDS;
        if (base != null) {
            Files2.deleteRecursively(base, path);
        } else {
            Files2.deleteRecursivelyInsecurely(path);
        }
    }

    public static void deleteRecursivelyEvenIfInsecure(DirectoryStream<Path> ds) throws IOException {
        Assert.checkNotNullParam((String)"ds", ds);
        if (ds instanceof SecureDirectoryStream) {
            SecureDirectoryStream sds = (SecureDirectoryStream)ds;
            Files2.deleteRecursively(sds);
        } else {
            Files2.deleteRecursivelyInsecurely(ds);
        }
    }

    public static void deleteRecursively(Path path) throws IOException {
        Assert.checkNotNullParam((String)"path", (Object)path);
        SecureDirectoryStream<Path> base = CWD_SDS;
        if (base == null) {
            throw Messages.log.secureDirectoryNotSupported(path.getFileSystem(), path);
        }
        Files2.deleteRecursively(base, path);
    }

    public static void deleteRecursively(SecureDirectoryStream<Path> sds) throws IOException {
        Assert.checkNotNullParam((String)"sds", sds);
        for (Path abs : sds) {
            Files2.deleteRecursively(sds, abs.getFileName());
        }
    }

    public static void deleteRecursively(SecureDirectoryStream<Path> sds, Path path) throws IOException {
        Messages.log.tracef("Securely deleting %s", path);
        Assert.checkNotNullParam((String)"sds", sds);
        Assert.checkNotNullParam((String)"path", (Object)path);
        if (sds.getFileAttributeView(path, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).readAttributes().isDirectory()) {
            try (SecureDirectoryStream<Path> subStream = sds.newDirectoryStream(path, LinkOption.NOFOLLOW_LINKS);){
                Messages.log.tracef("Entering directory %s", path);
                Files2.deleteRecursively(subStream);
                Messages.log.tracef("Exiting directory %s", path);
            }
            sds.deleteDirectory(path);
        } else {
            sds.deleteFile(path);
        }
    }

    public static DeleteStats deleteRecursivelyQuietlyEvenIfInsecure(Path path) {
        Assert.checkNotNullParam((String)"path", (Object)path);
        SecureDirectoryStream<Path> base = CWD_SDS;
        if (base != null) {
            return Files2.deleteRecursivelyQuietly(base, path);
        }
        long[] stats = new long[4];
        Files2.deleteRecursivelyQuietlyInsecurely(path, stats);
        return new DeleteStats(stats);
    }

    public static DeleteStats deleteRecursivelyQuietlyEvenIfInsecure(DirectoryStream<Path> ds) {
        Assert.checkNotNullParam((String)"ds", ds);
        if (ds instanceof SecureDirectoryStream) {
            SecureDirectoryStream sds = (SecureDirectoryStream)ds;
            return Files2.deleteRecursivelyQuietly(sds);
        }
        long[] stats = new long[4];
        Files2.deleteRecursivelyQuietlyInsecurely(ds, stats);
        return new DeleteStats(stats);
    }

    public static DeleteStats deleteRecursivelyQuietly(Path path) {
        Assert.checkNotNullParam((String)"path", (Object)path);
        SecureDirectoryStream<Path> base = CWD_SDS;
        if (base == null) {
            throw Messages.log.secureDirectoryNotSupported(path.getFileSystem(), path);
        }
        return Files2.deleteRecursivelyQuietly(base, path);
    }

    public static DeleteStats deleteRecursivelyQuietly(SecureDirectoryStream<Path> sds) {
        Assert.checkNotNullParam((String)"sds", sds);
        long[] stats = new long[4];
        Files2.deleteRecursivelyQuietly(sds, stats);
        return new DeleteStats(stats);
    }

    public static DeleteStats deleteRecursivelyQuietly(SecureDirectoryStream<Path> sds, Path path) {
        Assert.checkNotNullParam((String)"sds", sds);
        Assert.checkNotNullParam((String)"path", (Object)path);
        long[] stats = new long[4];
        Files2.deleteRecursivelyQuietly(sds, path, stats);
        return new DeleteStats(stats);
    }

    public static void cleanRecursivelyEvenIfInsecure(Path path) throws IOException {
        Assert.checkNotNullParam((String)"path", (Object)path);
        SecureDirectoryStream<Path> base = CWD_SDS;
        if (base != null) {
            Files2.cleanRecursively(base, path);
        } else {
            Files2.cleanRecursivelyInsecurely(path);
        }
    }

    public static void cleanRecursivelyEvenIfInsecure(DirectoryStream<Path> ds) throws IOException {
        Assert.checkNotNullParam((String)"ds", ds);
        if (ds instanceof SecureDirectoryStream) {
            SecureDirectoryStream sds = (SecureDirectoryStream)ds;
            Files2.cleanRecursively(sds);
        } else {
            Files2.cleanRecursivelyInsecurely(ds);
        }
    }

    public static void cleanRecursively(Path path) throws IOException {
        Assert.checkNotNullParam((String)"path", (Object)path);
        SecureDirectoryStream<Path> base = CWD_SDS;
        if (base == null) {
            throw Messages.log.secureDirectoryNotSupported(path.getFileSystem(), path);
        }
        Files2.cleanRecursively(base, path);
    }

    public static void cleanRecursively(SecureDirectoryStream<Path> sds) throws IOException {
        Assert.checkNotNullParam((String)"sds", sds);
        for (Path abs : sds) {
            Files2.cleanRecursively(sds, abs.getFileName());
        }
    }

    public static void cleanRecursively(SecureDirectoryStream<Path> sds, Path path) throws IOException {
        Assert.checkNotNullParam((String)"sds", sds);
        Assert.checkNotNullParam((String)"path", (Object)path);
        Messages.log.tracef("Cleaning %s", path);
        if (sds.getFileAttributeView(path, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).readAttributes().isDirectory()) {
            try (SecureDirectoryStream<Path> subStream = sds.newDirectoryStream(path, LinkOption.NOFOLLOW_LINKS);){
                Messages.log.tracef("Entering directory %s", path);
                Files2.cleanRecursively(subStream);
                Messages.log.tracef("Exiting directory %s", path);
            }
        } else {
            sds.deleteFile(path);
        }
    }

    public static Path getParent(Path path) {
        Assert.checkNotNullParam((String)"path", (Object)path);
        if (!path.isAbsolute()) {
            path = Files2.currentDirectory().resolve(path);
        }
        return path.normalize().getParent();
    }

    public static Path currentDirectory() {
        return CWD;
    }

    public static boolean hasSecureDirectories() {
        return CWD_SDS != null;
    }

    private static void deleteRecursivelyInsecurely(DirectoryStream<Path> ds) throws IOException {
        for (Path path : ds) {
            Files2.deleteRecursivelyEvenIfInsecure(path);
        }
    }

    private static void deleteRecursivelyInsecurely(Path path) throws IOException {
        Messages.log.tracef("Insecurely deleting path %s", path);
        if (Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(path);){
                Files2.deleteRecursivelyEvenIfInsecure(ds);
            }
        }
        Files.delete(path);
    }

    private static void deleteRecursivelyQuietly(SecureDirectoryStream<Path> sds, Path path, long[] stats) {
        boolean isDirectory;
        try {
            isDirectory = sds.getFileAttributeView(path, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).readAttributes().isDirectory();
        }
        catch (NoSuchFileException ignored) {
            return;
        }
        catch (IOException ignored) {
            isDirectory = false;
        }
        if (isDirectory) {
            stats[0] = stats[0] + 1L;
            try (SecureDirectoryStream<Path> subStream2 = sds.newDirectoryStream(path, LinkOption.NOFOLLOW_LINKS);){
                Messages.log.tracef("Entering directory %s", path);
                Files2.deleteRecursivelyQuietly(subStream2, stats);
                Messages.log.tracef("Exiting directory %s", path);
            }
            catch (IOException subStream2) {
                // empty catch block
            }
            try {
                sds.deleteDirectory(path);
                stats[1] = stats[1] + 1L;
            }
            catch (IOException subStream2) {}
        } else {
            stats[2] = stats[2] + 1L;
            try {
                sds.deleteFile(path);
                stats[3] = stats[3] + 1L;
            }
            catch (NoSuchFileException ignored) {
                stats[2] = stats[2] - 1L;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void deleteRecursivelyQuietly(SecureDirectoryStream<Path> subStream, long[] stats) {
        for (Path path : subStream) {
            Files2.deleteRecursivelyQuietly(subStream, path.getFileName(), stats);
        }
    }

    private static void deleteRecursivelyQuietlyInsecurely(Path path, long[] stats) {
        if (Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
            stats[0] = stats[0] + 1L;
            try (DirectoryStream<Path> ds2 = Files.newDirectoryStream(path);){
                Files2.deleteRecursivelyQuietlyInsecurely(ds2, stats);
            }
            catch (IOException ds2) {
                // empty catch block
            }
            try {
                Files.delete(path);
                stats[1] = stats[1] + 1L;
            }
            catch (IOException ds2) {}
        } else {
            stats[2] = stats[2] + 1L;
            try {
                Files.delete(path);
                stats[3] = stats[3] + 1L;
            }
            catch (NoSuchFileException ignored) {
                stats[2] = stats[2] - 1L;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void deleteRecursivelyQuietlyInsecurely(DirectoryStream<Path> ds, long[] stats) {
        for (Path path : ds) {
            Files2.deleteRecursivelyQuietlyInsecurely(path, stats);
        }
    }

    private static void cleanRecursivelyInsecurely(DirectoryStream<Path> ds) throws IOException {
        for (Path path : ds) {
            Files2.cleanRecursivelyEvenIfInsecure(path);
        }
    }

    private static void cleanRecursivelyInsecurely(Path path) throws IOException {
        Messages.log.tracef("Insecurely cleaning path %s", path);
        if (Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(path);){
                Files2.cleanRecursivelyEvenIfInsecure(ds);
            }
        } else {
            Files.delete(path);
        }
    }

    static {
        SecureDirectoryStream cwdSds;
        block5: {
            CWD = Path.of(System.getProperty("user.dir", "."), new String[0]).normalize().toAbsolutePath();
            try {
                DirectoryStream<Path> ds = Files.newDirectoryStream(CWD);
                if (ds instanceof SecureDirectoryStream) {
                    SecureDirectoryStream sds;
                    cwdSds = sds = (SecureDirectoryStream)ds;
                    break block5;
                }
                try {
                    ds.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                cwdSds = null;
            }
            catch (IOException ignored) {
                cwdSds = null;
            }
        }
        CWD_SDS = cwdSds;
    }
}

