/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.certs;

import io.smallrye.certs.CertificateFiles;
import io.smallrye.certs.Format;
import java.nio.file.Path;

public final class PemCertificateFiles
implements CertificateFiles {
    private final Path root;
    private final String name;
    private final boolean client;
    private final String password;
    private final Path certFile;
    private final Path keyFile;
    private final Path trustFile;
    private final Path clientCertFile;
    private final Path clientKeyFile;
    private final Path serverTrustFile;

    public PemCertificateFiles(Path root, String name, boolean client, String password) {
        this.root = root;
        this.name = name;
        this.client = client;
        this.certFile = root.resolve(name + ".crt");
        this.keyFile = root.resolve(name + ".key");
        this.trustFile = root.resolve(name + (client ? "-client" : "") + "-ca.crt");
        this.clientCertFile = root.resolve(name + "-client.crt");
        this.clientKeyFile = root.resolve(name + "-client.key");
        this.serverTrustFile = root.resolve(name + "-server-ca.crt");
        this.password = password;
    }

    @Override
    public Format format() {
        if (this.password != null) {
            return Format.ENCRYPTED_PEM;
        }
        return Format.PEM;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Path root() {
        return this.root;
    }

    @Override
    public boolean client() {
        return this.client;
    }

    @Override
    public String password() {
        return this.password;
    }

    @Override
    public Path trustStore() {
        return this.client ? this.serverTrustFile : this.trustFile;
    }

    public String toString() {
        return "PemCertificateFiles{root=" + String.valueOf(this.root) + ", name='" + this.name + "', client=" + this.client + "}";
    }

    public Path certFile() {
        return this.certFile;
    }

    public Path keyFile() {
        return this.keyFile;
    }

    public Path trustFile() {
        return this.trustFile;
    }

    public Path clientCertFile() {
        return this.clientCertFile;
    }

    public Path clientKeyFile() {
        return this.clientKeyFile;
    }

    public Path serverTrustFile() {
        return this.serverTrustFile;
    }
}

