/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.store.db.sql.distributed.lock;

import io.seata.core.store.db.sql.distributed.lock.DistributedLockSql;

public class BaseDistributedLockSql
implements DistributedLockSql {
    protected static final String DISTRIBUTED_LOCK_TABLE_PLACE_HOLD = " #distributed_lock_table# ";
    protected static final String ALL_COLUMNS = "lock_key,lock_value,expire";
    protected static final String SELECT_FOR_UPDATE_SQL = "SELECT lock_key,lock_value,expire FROM  #distributed_lock_table#  WHERE lock_key = ? FOR UPDATE";
    protected static final String INSERT_DISTRIBUTED_LOCK_SQL = "INSERT INTO  #distributed_lock_table# (lock_key,lock_value,expire) VALUE (?, ?, ?)";
    protected static final String UPDATE_DISTRIBUTED_LOCK_SQL = "UPDATE  #distributed_lock_table#  SET lock_value=?, expire=? WHERE lock_key=?";

    @Override
    public String getSelectDistributeForUpdateSql(String distributedLockTable) {
        return SELECT_FOR_UPDATE_SQL.replace(DISTRIBUTED_LOCK_TABLE_PLACE_HOLD, distributedLockTable);
    }

    @Override
    public String getInsertSql(String distributedLockTable) {
        return INSERT_DISTRIBUTED_LOCK_SQL.replace(DISTRIBUTED_LOCK_TABLE_PLACE_HOLD, distributedLockTable);
    }

    @Override
    public String getUpdateSql(String distributedLockTable) {
        return UPDATE_DISTRIBUTED_LOCK_SQL.replace(DISTRIBUTED_LOCK_TABLE_PLACE_HOLD, distributedLockTable);
    }
}

