/*
 * Decompiled with CFR 0.152.
 */
package restx.specs;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import restx.common.MoreStrings;
import restx.specs.ThenHttpResponse;
import restx.specs.When;

public class WhenHttpRequest
extends When<ThenHttpResponse> {
    public static final String CONTEXT_NAME = "WhenHttpRequest.CONTEXT_NAME";
    public static final String BASE_URL = "WhenHttpRequest.BASE_URL";
    private final String method;
    private final String path;
    private final String body;
    private final ImmutableMap<String, String> cookies;

    public WhenHttpRequest(String method, String path, Map<String, String> cookies, String body, ThenHttpResponse then) {
        super(then);
        this.method = method;
        this.path = path;
        this.body = body;
        this.cookies = ImmutableMap.copyOf(cookies);
    }

    @Override
    public void toString(StringBuilder sb) {
        if (Strings.isNullOrEmpty((String)this.body) && this.cookies.isEmpty()) {
            sb.append("  - when: ").append(this.method).append(" ").append(this.path).append("\n");
        } else {
            sb.append("  - when: |\n").append("       ").append(this.method).append(" ").append(this.path).append("\n");
            if (!this.cookies.isEmpty()) {
                sb.append("       Cookie: ");
                for (Map.Entry entry : this.cookies.entrySet()) {
                    sb.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append("; ");
                }
                sb.setLength(sb.length() - 2);
                sb.append("\n");
            }
            if (!Strings.isNullOrEmpty((String)this.body)) {
                sb.append("\n").append(MoreStrings.indent((String)this.body.trim(), (int)8)).append("\n");
            }
        }
        ((ThenHttpResponse)this.getThen()).toString(sb);
    }

    public String getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public String getBody() {
        return this.body;
    }

    public ImmutableMap<String, String> getCookies() {
        return this.cookies;
    }

    @Override
    public When<ThenHttpResponse> withThen(ThenHttpResponse then) {
        return new WhenHttpRequest(this.method, this.path, (Map<String, String>)this.cookies, this.body, then);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String method;
        private String path;
        private String body;
        private Map<String, String> cookies = Maps.newLinkedHashMap();
        private ThenHttpResponse response;

        public Builder withMethod(String method) {
            this.method = method;
            return this;
        }

        public Builder withPath(String path) {
            this.path = path;
            return this;
        }

        public Builder withBody(String body) {
            this.body = body;
            return this;
        }

        public Builder addCookie(String key, String value) {
            this.cookies.put(key, value);
            return this;
        }

        public boolean containsCookie(String key) {
            return this.cookies.containsKey(key);
        }

        public Builder withThen(ThenHttpResponse response) {
            this.response = response;
            return this;
        }

        public WhenHttpRequest build() {
            return new WhenHttpRequest(this.method, this.path, this.cookies, this.body, this.response);
        }
    }
}

