/*
 * Decompiled with CFR 0.152.
 */
package restx.specs;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import restx.common.UUIDGenerator;
import restx.factory.BoundlessComponentBox;
import restx.factory.Component;
import restx.factory.ComponentCustomizerEngine;
import restx.factory.Factory;
import restx.factory.FactoryMachine;
import restx.factory.MachineEngine;
import restx.factory.Name;
import restx.factory.NamedComponent;
import restx.factory.NoDepsMachineEngine;
import restx.factory.SatisfiedBOM;
import restx.factory.SingleComponentClassCustomizerEngine;
import restx.factory.SingleNameFactoryMachine;
import restx.specs.Given;
import restx.specs.GivenUUIDGenerator;
import restx.specs.RestxSpecRecorder;

@Component
public class GivenUUIDGeneratorRecorder
implements RestxSpecRecorder.GivenRecorder {
    @Override
    public AutoCloseable recordIn(Map<String, Given> givens) {
        final Tape tape = new Tape(givens);
        Factory.LocalMachines.threadLocal().addMachine((FactoryMachine)new SingleNameFactoryMachine(0, (MachineEngine)new NoDepsMachineEngine<ComponentCustomizerEngine>(Name.of(ComponentCustomizerEngine.class, (String)"UUIDGeneratorSequenceSupplier"), BoundlessComponentBox.FACTORY){

            protected ComponentCustomizerEngine doNewComponent(SatisfiedBOM satisfiedBOM) {
                return new SingleComponentClassCustomizerEngine<UUIDGenerator>(0, UUIDGenerator.class){

                    public NamedComponent<UUIDGenerator> customize(final NamedComponent<UUIDGenerator> namedComponent) {
                        return new NamedComponent(namedComponent.getName(), (Object)new UUIDGenerator(){

                            public String doGenerate() {
                                String uuid = ((UUIDGenerator)namedComponent.getComponent()).doGenerate();
                                tape.recordGeneratedId(uuid);
                                return uuid;
                            }
                        });
                    }
                };
            }
        }));
        return tape;
    }

    private static class Tape
    implements AutoCloseable {
        private final Map<String, Given> givens;
        private GivenUUIDGenerator givenUUIDGenerator;

        private Tape(Map<String, Given> givens) {
            this.givens = givens;
            this.givenUUIDGenerator = new GivenUUIDGenerator((ImmutableList<String>)ImmutableList.of());
        }

        @Override
        public void close() throws Exception {
            if (!this.givenUUIDGenerator.getPlaybackUUIDs().isEmpty()) {
                this.givens.put("uuids", this.givenUUIDGenerator);
            }
        }

        private void recordGeneratedId(String uuid) {
            this.givenUUIDGenerator = this.givenUUIDGenerator.concat(uuid);
        }
    }
}

