/*
 * Decompiled with CFR 0.152.
 */
package restx.security;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.concurrent.ConcurrentMap;

public class Sessions {
    private final ConcurrentMap<String, SessionData> sessions = Maps.newConcurrentMap();
    private final int limit;

    public Sessions(int limit) {
        this.limit = limit;
    }

    public Optional<SessionData> get(String key) {
        return Optional.fromNullable(this.sessions.get(key));
    }

    public ImmutableMap<String, SessionData> getAll() {
        return ImmutableMap.copyOf(this.sessions);
    }

    public SessionData touch(String key, ImmutableMap<String, String> metadata) {
        SessionData sessionData;
        SessionData updatedSessionData;
        boolean updated = false;
        do {
            if ((sessionData = (SessionData)this.sessions.get(key)) != null) {
                updatedSessionData = sessionData.touch((ImmutableMap<String, String>)metadata);
                continue;
            }
            long access = System.currentTimeMillis();
            updatedSessionData = new SessionData(key, access, access, System.nanoTime(), 1, metadata);
        } while (!(updated = this.sessions.put(key, updatedSessionData) == sessionData));
        int size = this.sessions.size();
        int remainingChecks = (size - this.limit) * 3 + 100;
        while (this.sessions.size() > this.limit) {
            if (remainingChecks-- == 0) {
                throw new IllegalStateException(String.format("didn't manage to limit the size of sessions data within a reasonnable (%d) number of attempts", (size - this.limit) * 3 + 100));
            }
            SessionData oldest = (SessionData)Ordering.natural().leastOf(this.sessions.values(), 1).get(0);
            if (this.sessions.size() <= this.limit) continue;
            this.sessions.remove(oldest.getKey(), oldest);
        }
        return updatedSessionData;
    }

    public static final class SessionData
    implements Comparable<SessionData> {
        private final String key;
        private final long firstAccess;
        private final long lastAccess;
        private final long lastAccessNano;
        private final int count;
        private final ImmutableMap<String, String> metadata;

        private SessionData(String key, long firstAccess, long lastAccess, long lastAccessNano, int count, ImmutableMap<String, String> metadata) {
            this.key = (String)Preconditions.checkNotNull((Object)key);
            this.firstAccess = firstAccess;
            this.lastAccess = lastAccess;
            this.lastAccessNano = lastAccessNano;
            this.count = count;
            this.metadata = (ImmutableMap)Preconditions.checkNotNull(metadata);
        }

        public String getKey() {
            return this.key;
        }

        public long getFirstAccess() {
            return this.firstAccess;
        }

        public long getLastAccess() {
            return this.lastAccess;
        }

        public int getCount() {
            return this.count;
        }

        public ImmutableMap<String, String> getMetadata() {
            return this.metadata;
        }

        private SessionData touch(ImmutableMap<String, String> metadata) {
            return new SessionData(this.key, this.firstAccess, System.currentTimeMillis(), System.nanoTime(), this.count + 1, metadata);
        }

        public String toString() {
            return "SessionData{key='" + this.key + '\'' + ", firstAccess=" + this.firstAccess + ", lastAccess=" + this.lastAccess + ", metadata=" + this.metadata + '}';
        }

        @Override
        public int compareTo(SessionData o) {
            return (int)(this.lastAccessNano - o.lastAccessNano);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SessionData that = (SessionData)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

