/*
 * Decompiled with CFR 0.152.
 */
package restx.security;

import com.google.common.base.Optional;
import java.io.IOException;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import restx.RestxContext;
import restx.RestxHandler;
import restx.RestxHandlerMatch;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;
import restx.RestxRoute;
import restx.StdRestxRequestMatch;
import restx.WebException;
import restx.common.RestxConfig;
import restx.config.SettingsKey;
import restx.factory.AutoStartable;
import restx.factory.Module;
import restx.factory.Provides;
import restx.factory.When;
import restx.http.HttpStatus;
import restx.security.GuavaEntryCacheManager;
import restx.security.RestxSession;
import restx.security.Sessions;

@Module(priority=100)
public class SecurityModule {
    private static final Logger logger = LoggerFactory.getLogger(SecurityModule.class);
    public static final String ENTRY_CACHE_MANAGER = "EntryCacheManager";

    @Named(value="restx.activation::restx.security.RestxSessionBareFilter::RestxSessionBareFilter")
    @Provides
    public String disableBareFilter() {
        return "false";
    }

    @Named(value="Sessions")
    @Provides
    public Sessions session(SecuritySettings settings) {
        return new Sessions(settings.sessionsLimit());
    }

    @Provides
    public AutoStartable startSessions(@Named(value="Sessions") Sessions sessions) {
        return new AutoStartable(){

            public void start() {
                logger.debug("starting sessions statistics");
            }
        };
    }

    @Provides
    public SecuritySettings securitySettings(final RestxConfig config) {
        return new SecuritySettings(){

            @Override
            public int sessionsLimit() {
                return (Integer)config.getInt("restx.sessions.stats.limit").or((Object)100);
            }
        };
    }

    @Named(value="EntryCacheManager")
    @Provides
    public RestxSession.Definition.EntryCacheManager guavaCacheManager() {
        return new GuavaEntryCacheManager();
    }

    @Provides(priority=100000)
    @When(name="restx.mode", value="prod")
    public RestxRoute productionNotFoundHandler() {
        return new RestxRoute(){

            @Override
            public Optional<RestxHandlerMatch> match(RestxRequest req) {
                return Optional.of((Object)new RestxHandlerMatch(new StdRestxRequestMatch("*", req.getRestxPath()), new RestxHandler(){

                    @Override
                    public void handle(RestxRequestMatch match, RestxRequest req, RestxResponse resp, RestxContext ctx) throws IOException {
                        throw new WebException(HttpStatus.NOT_FOUND);
                    }
                }));
            }
        };
    }

    public static interface SecuritySettings {
        @SettingsKey(key="restx.sessions.stats.limit", defaultValue="100", doc="The maximum number of sessions data to keep in memory for statistics in the monitor view")
        public int sessionsLimit();
    }
}

