/*
 * Decompiled with CFR 0.152.
 */
package restx.security;

import com.google.common.base.Optional;
import restx.http.HTTP;

public class RestxSessionCookieDescriptor {
    private String cookieName;
    private String cookieSignatureName;
    private String domain;
    private Boolean secure;

    public RestxSessionCookieDescriptor(String cookieName, String cookieSignatureName) {
        this(cookieName, cookieSignatureName, (Optional<String>)Optional.absent(), (Optional<Boolean>)Optional.absent());
    }

    public RestxSessionCookieDescriptor(String cookieName, String cookieSignatureName, Optional<String> domain, Optional<Boolean> secure) {
        this.cookieName = HTTP.headerTokenCompatible(cookieName, "_");
        this.cookieSignatureName = HTTP.headerTokenCompatible(cookieSignatureName, "_");
        this.domain = (String)domain.orNull();
        this.secure = (Boolean)secure.orNull();
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public String getCookieSignatureName() {
        return this.cookieSignatureName;
    }

    public Optional<String> getDomain() {
        return Optional.fromNullable((Object)this.domain);
    }

    public Optional<Boolean> getSecure() {
        return Optional.fromNullable((Object)this.secure);
    }
}

