/*
 * Decompiled with CFR 0.152.
 */
package restx.security;

import com.google.common.collect.ImmutableSet;
import restx.factory.BillOfMaterials;
import restx.factory.BoundlessComponentBox;
import restx.factory.Factory;
import restx.factory.Machine;
import restx.factory.MachineEngine;
import restx.factory.Name;
import restx.factory.SatisfiedBOM;
import restx.factory.SingleNameFactoryMachine;
import restx.factory.StdMachineEngine;
import restx.security.CORSAuthorizer;
import restx.security.CORSFilter;

@Machine
public class CORSFilterFactoryMachine
extends SingleNameFactoryMachine<CORSFilter> {
    public static final Name<CORSFilter> NAME = Name.of(CORSFilter.class, (String)"CORSFilter");

    public CORSFilterFactoryMachine() {
        super(0, (MachineEngine)new StdMachineEngine<CORSFilter>(NAME, 0, BoundlessComponentBox.FACTORY){
            private final Factory.Query<CORSAuthorizer> authorizers = Factory.Query.byClass(CORSAuthorizer.class).optional();

            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.of(this.authorizers));
            }

            protected CORSFilter doNewComponent(SatisfiedBOM satisfiedBOM) {
                return new CORSFilter(satisfiedBOM.getAsComponents(this.authorizers));
            }
        });
    }
}

