/*
 * Decompiled with CFR 0.152.
 */
package restx.http;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Properties;

public class HTTP {
    private static final Properties mimeTypes = new Properties();
    private static final String RFC_2616_TOKEN_SPECIAL_CHARS_REGEX = "[\\s\\(\\)<>@,;:\\\\\"/\\[\\]\\?=\\{\\}]";

    public static Optional<String> getContentTypeFromExtension(String filename) {
        String ext = filename.substring(filename.lastIndexOf(46) + 1);
        return Optional.fromNullable((Object)mimeTypes.getProperty(ext));
    }

    public static boolean isTextContentType(String contentType) {
        return contentType.startsWith("text/") || contentType.startsWith("application/json") || contentType.startsWith("application/javascript") || contentType.startsWith("application/ecmascript") || contentType.startsWith("application/atom+xml") || contentType.startsWith("application/rss+xml") || contentType.startsWith("application/xhtml+xml") || contentType.startsWith("application/soap+xml") || contentType.startsWith("application/xml");
    }

    public static Optional<String> charsetFromContentType(String s) {
        if (s.indexOf("charset=") == -1) {
            return Optional.absent();
        }
        return Optional.of((Object)s.substring(s.indexOf("charset=") + "charset=".length()));
    }

    public static String headerTokenCompatible(String s, String specialCharsReplacement) {
        Preconditions.checkArgument((boolean)specialCharsReplacement.replaceAll(RFC_2616_TOKEN_SPECIAL_CHARS_REGEX, "blah").equals(specialCharsReplacement), (String)"specialCharsReplacement `%s` is not itself compatible with rfc 2616 !", (Object[])new Object[]{specialCharsReplacement});
        return s.replaceAll(RFC_2616_TOKEN_SPECIAL_CHARS_REGEX, specialCharsReplacement);
    }

    static {
        try {
            mimeTypes.load(HTTP.class.getResourceAsStream("mime-types.properties"));
            for (String prop : mimeTypes.stringPropertyNames()) {
                Iterable types = Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)mimeTypes.getProperty(prop));
                mimeTypes.setProperty(prop, (String)Iterables.getFirst((Iterable)types, (Object)"application/octet-stream"));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

