/*
 * Decompiled with CFR 0.152.
 */
package restx.http;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadablePeriod;
import restx.RestxRequest;
import restx.RestxResponse;
import restx.StdRoute;
import restx.annotations.ExpiresAfter;
import restx.common.MorePeriods;
import restx.description.OperationDescription;
import restx.description.ResourceDescription;
import restx.factory.Component;
import restx.http.CurrentLocaleResolver;
import restx.http.EntityRelatedFilter;

@Component
public class ExpiresHeaderFilter
extends EntityRelatedFilter {
    private CurrentLocaleResolver currentLocaleResolver;

    public ExpiresHeaderFilter(@Named(value="CurrentLocaleResolver") CurrentLocaleResolver currentLocaleResolver) {
        super((Predicate<StdRoute>)Predicates.alwaysTrue(), (Predicate<ResourceDescription>)Predicates.alwaysTrue(), new OperationDescription.Matcher().havingAnyAnnotations(ExpiresAfter.class));
        this.currentLocaleResolver = currentLocaleResolver;
    }

    @Override
    protected void onEntityOutput(StdRoute stdRoute, RestxRequest req, RestxResponse resp, Optional<?> input, Optional<?> output, ResourceDescription resourceDescription, OperationDescription operationDescription) {
        if (!output.isPresent()) {
            return;
        }
        ExpiresAfter expiresAfterAnn = (ExpiresAfter)operationDescription.findAnnotation(ExpiresAfter.class).get();
        Locale currentLocale = this.currentLocaleResolver.guessLocale(req);
        DateTime expirationDate = DateTime.now().plus((ReadablePeriod)MorePeriods.parsePeriod((String)expiresAfterAnn.value(), (Locale)currentLocale));
        String expiresHeaderValue = ExpiresHeaderFilter.createRFC1123DateFormat(currentLocale).format(expirationDate.toDate());
        resp.setHeader("Expires", expiresHeaderValue);
    }

    public static DateFormat createRFC1123DateFormat(Locale locale) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", locale);
        dateFormat.setTimeZone(DateTimeZone.UTC.toTimeZone());
        return dateFormat;
    }
}

