/*
 * Decompiled with CFR 0.152.
 */
package restx.http;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import restx.AbstractRouteLifecycleListener;
import restx.RestxContext;
import restx.RestxHandler;
import restx.RestxHandlerMatch;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;
import restx.RestxRoute;
import restx.RestxRouteFilter;
import restx.StdRestxRequestMatch;
import restx.StdRoute;
import restx.description.OperationDescription;
import restx.description.ResourceDescription;

public abstract class EntityRelatedFilter
implements RestxRouteFilter {
    private final Predicate<StdRoute> routeMatcher;
    private final Predicate<ResourceDescription> resourceDescriptionMatcher;
    private final Predicate<OperationDescription> operationDescriptionMatcher;

    public EntityRelatedFilter(Predicate<StdRoute> routeMatcher, Predicate<ResourceDescription> resourceDescriptionMatcher, Predicate<OperationDescription> operationDescriptionMatcher) {
        this.routeMatcher = routeMatcher;
        this.resourceDescriptionMatcher = resourceDescriptionMatcher;
        this.operationDescriptionMatcher = operationDescriptionMatcher;
    }

    @Override
    public Optional<RestxHandlerMatch> match(RestxRoute route) {
        if (!(route instanceof StdRoute)) {
            return Optional.absent();
        }
        final StdRoute stdRoute = (StdRoute)route;
        Collection<ResourceDescription> resourceDescriptionColl = stdRoute.describe();
        if (resourceDescriptionColl.isEmpty()) {
            return Optional.absent();
        }
        final ResourceDescription resourceDescription = (ResourceDescription)Iterables.getOnlyElement(resourceDescriptionColl);
        if (resourceDescription.operations == null || resourceDescription.operations.isEmpty()) {
            return Optional.absent();
        }
        final OperationDescription operationDescription = (OperationDescription)Iterables.getOnlyElement(resourceDescription.operations);
        if (!this.matches(stdRoute, resourceDescription, operationDescription)) {
            return Optional.absent();
        }
        return Optional.of((Object)new RestxHandlerMatch(new StdRestxRequestMatch("/*"), new RestxHandler(){

            @Override
            public void handle(RestxRequestMatch match, RestxRequest req, RestxResponse resp, RestxContext ctx) throws IOException {
                ctx.nextHandlerMatch().handle(req, resp, ctx.withListener(new AbstractRouteLifecycleListener(){

                    @Override
                    public void onBeforeWriteContent(RestxRequest req, RestxResponse resp) {
                        EntityRelatedFilter.this.onBeforeWriteContent(req, resp, resourceDescription, operationDescription);
                    }

                    @Override
                    public void onAfterWriteContent(RestxRequest req, RestxResponse resp) {
                        EntityRelatedFilter.this.onAfterWriteContent(req, resp, resourceDescription, operationDescription);
                    }

                    @Override
                    public void onEntityInput(RestxRoute route, RestxRequest req, RestxResponse resp, Optional<?> input) {
                        EntityRelatedFilter.this.onEntityInput(stdRoute, req, resp, input, resourceDescription, operationDescription);
                    }

                    @Override
                    public void onEntityOutput(RestxRoute route, RestxRequest req, RestxResponse resp, Optional<?> input, Optional<?> output) {
                        EntityRelatedFilter.this.onEntityOutput(stdRoute, req, resp, input, output, resourceDescription, operationDescription);
                    }
                }));
            }
        }));
    }

    protected void onEntityInput(StdRoute stdRoute, RestxRequest req, RestxResponse resp, Optional<?> input, ResourceDescription resourceDescription, OperationDescription operationDescription) {
    }

    protected void onBeforeWriteContent(RestxRequest req, RestxResponse resp, ResourceDescription resourceDescription, OperationDescription operationDescription) {
    }

    protected void onEntityOutput(StdRoute stdRoute, RestxRequest req, RestxResponse resp, Optional<?> input, Optional<?> output, ResourceDescription resourceDescription, OperationDescription operationDescription) {
    }

    protected void onAfterWriteContent(RestxRequest req, RestxResponse resp, ResourceDescription resourceDescription, OperationDescription operationDescription) {
    }

    protected boolean matches(StdRoute route, ResourceDescription resourceDescription, OperationDescription operationDescription) {
        return this.routeMatcher.apply((Object)route) && this.resourceDescriptionMatcher.apply((Object)resourceDescription) && this.operationDescriptionMatcher.apply((Object)operationDescription);
    }
}

