/*
 * Decompiled with CFR 0.152.
 */
package restx.exceptions;

import restx.common.UUIDGenerator;
import restx.exceptions.ErrorCode;
import restx.exceptions.RestxError;
import restx.factory.Component;
import restx.http.HttpStatus;

@Component
public class RestxErrors {
    private final UUIDGenerator uuidGenerator;

    public RestxErrors(UUIDGenerator uuidGenerator) {
        this.uuidGenerator = uuidGenerator;
    }

    public <E> RestxError<E> on(Class<E> errorCode) {
        ErrorCode code = errorCode.getAnnotation(ErrorCode.class);
        HttpStatus errorStatus = code != null ? code.status() : HttpStatus.BAD_REQUEST;
        String error = code != null ? code.code() : errorCode.getSimpleName();
        String description = code != null ? code.description() : errorCode.getName();
        return new RestxError(this.uuidGenerator.doGenerate(), errorStatus, error, description);
    }
}

