/*
 * Decompiled with CFR 0.152.
 */
package restx.entity;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import restx.RestxContext;
import restx.RestxLogLevel;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;
import restx.RouteLifecycleListener;
import restx.StdRestxRequestMatcher;
import restx.StdRoute;
import restx.endpoint.Endpoint;
import restx.endpoint.EndpointParamDef;
import restx.endpoint.EndpointParameterKind;
import restx.endpoint.EndpointParameterMapperRegistry;
import restx.endpoint.mappers.EndpointParameterMapper;
import restx.entity.EntityRequestBodyReader;
import restx.entity.EntityResponseWriter;
import restx.entity.MatchedEntityRoute;
import restx.entity.VoidContentTypeModule;
import restx.factory.ParamDef;
import restx.http.HttpStatus;
import restx.security.Permission;
import restx.security.PermissionFactory;

public abstract class StdEntityRoute<I, O>
extends StdRoute {
    protected static final Supplier<List> EMPTY_LIST_SUPPLIER = new Supplier<List>(){

        public List get() {
            return Collections.emptyList();
        }
    };
    protected static final Supplier<Set> EMPTY_SET_SUPPLIER = new Supplier<Set>(){

        public Set get() {
            return Collections.emptySet();
        }
    };
    protected static final Supplier<Iterable> EMPTY_ITERABLE_SUPPLIER = new Supplier<Iterable>(){

        public Iterable get() {
            return Collections.emptyList();
        }
    };
    protected static final Supplier<Collection> EMPTY_COLLECTION_SUPPLIER = new Supplier<Collection>(){

        public Collection get() {
            return Collections.emptySet();
        }
    };
    private final EntityRequestBodyReader<I> entityRequestBodyReader;
    private final EntityResponseWriter<O> entityResponseWriter;
    private final RestxLogLevel logLevel;
    private final Endpoint endpoint;
    private final PermissionFactory permissionFactory;
    private final Map<String, EndpointParameterMapperAndDef> cachedQueryParameterMappers;

    public static <I, O> Builder<I, O> builder() {
        return new Builder();
    }

    public StdEntityRoute(String name, EntityRequestBodyReader<I> entityRequestBodyReader, EntityResponseWriter<O> entityResponseWriter, Endpoint endpoint, HttpStatus successStatus, RestxLogLevel logLevel, PermissionFactory permissionFactory, EndpointParameterMapperRegistry registry) {
        this(name, entityRequestBodyReader, entityResponseWriter, endpoint, successStatus, logLevel, permissionFactory, registry, new ParamDef[0]);
    }

    public StdEntityRoute(String name, EntityRequestBodyReader<I> entityRequestBodyReader, EntityResponseWriter<O> entityResponseWriter, Endpoint endpoint, HttpStatus successStatus, RestxLogLevel logLevel, PermissionFactory permissionFactory, EndpointParameterMapperRegistry registry, ParamDef[] queryParametersDefinition) {
        super(name, new StdRestxRequestMatcher(endpoint), successStatus);
        this.endpoint = endpoint;
        this.permissionFactory = permissionFactory;
        this.entityRequestBodyReader = (EntityRequestBodyReader)Preconditions.checkNotNull(entityRequestBodyReader);
        this.entityResponseWriter = (EntityResponseWriter)Preconditions.checkNotNull(entityResponseWriter);
        this.logLevel = (RestxLogLevel)((Object)Preconditions.checkNotNull((Object)((Object)logLevel)));
        this.cachedQueryParameterMappers = StdEntityRoute.cacheQueryParameterMappers(registry, endpoint, queryParametersDefinition);
    }

    private static Map<String, EndpointParameterMapperAndDef> cacheQueryParameterMappers(EndpointParameterMapperRegistry registry, Endpoint endpoint, ParamDef[] parameters) {
        HashMap<String, EndpointParameterMapperAndDef> cachedParameterMappers = new HashMap<String, EndpointParameterMapperAndDef>();
        for (ParamDef parameter : parameters) {
            EndpointParamDef endpointParamDefDef = new EndpointParamDef(endpoint, parameter);
            cachedParameterMappers.put(parameter.getName(), new EndpointParameterMapperAndDef(registry.getEndpointParameterMapperFor(endpointParamDefDef), endpointParamDefDef));
        }
        return cachedParameterMappers;
    }

    public Type getEntityRequestBodyType() {
        return this.entityRequestBodyReader.getType();
    }

    public Type getEntityResponseType() {
        return this.entityResponseWriter.getType();
    }

    protected <T> T mapQueryObjectFromRequest(Class<T> targetType, String parameterName, RestxRequest request, RestxRequestMatch match, EndpointParameterKind endpointParameterKind) {
        return this.mapQueryObjectFromRequest(targetType, parameterName, request, match, endpointParameterKind, null);
    }

    protected <T> T mapQueryObjectFromRequest(Class<T> targetType, String parameterName, RestxRequest request, RestxRequestMatch match, EndpointParameterKind endpointParameterKind, Supplier<T> nullResultDefaultValueSupplier) {
        EndpointParameterMapperAndDef endpointParameterMapperAndDef = this.cachedQueryParameterMappers.get(parameterName);
        if (endpointParameterMapperAndDef == null) {
            throw new IllegalStateException("No cachedQueryParameterMappers for parameter " + parameterName + " : please provide corresponding ParamDef at instanciation time !");
        }
        Object result = endpointParameterMapperAndDef.mapper.mapRequest(endpointParameterMapperAndDef.endpointParamDef, request, match, endpointParameterKind);
        if (nullResultDefaultValueSupplier != null && result == null) {
            result = nullResultDefaultValueSupplier.get();
        }
        return result;
    }

    @Override
    public void handle(RestxRequestMatch match, RestxRequest req, RestxResponse resp, RestxContext ctx) throws IOException {
        RouteLifecycleListener lifecycleListener = ctx.getLifecycleListener();
        resp.setLogLevel(this.logLevel);
        lifecycleListener.onRouteMatch(this, req, resp);
        I input = this.entityRequestBodyReader.readBody(req, ctx);
        Optional optionalInput = Optional.fromNullable(input);
        lifecycleListener.onEntityInput(this, req, resp, optionalInput);
        Optional<O> result = this.doRoute(req, resp, match, input);
        lifecycleListener.onEntityOutput(this, req, resp, optionalInput, result);
        if (result.isPresent()) {
            this.entityResponseWriter.sendResponse(this.getSuccessStatus(), result.get(), req, resp, ctx);
        } else {
            this.notFound(match, resp);
        }
    }

    protected abstract Optional<O> doRoute(RestxRequest var1, RestxResponse var2, RestxRequestMatch var3, I var4) throws IOException;

    protected Permission hasRole(String role) {
        return this.permissionFactory.hasRole(role);
    }

    protected Permission anyOf(Permission ... permissions) {
        return this.permissionFactory.anyOf(permissions);
    }

    protected Permission allOf(Permission ... permissions) {
        return this.permissionFactory.allOf(permissions);
    }

    protected Permission open() {
        return this.permissionFactory.open();
    }

    protected Permission isAuthenticated() {
        return this.permissionFactory.isAuthenticated();
    }

    private static class EndpointParameterMapperAndDef {
        EndpointParameterMapper mapper;
        EndpointParamDef endpointParamDef;

        public EndpointParameterMapperAndDef(EndpointParameterMapper mapper, EndpointParamDef endpointParamDef) {
            this.mapper = mapper;
            this.endpointParamDef = endpointParamDef;
        }
    }

    public static class Builder<I, O> {
        protected EntityRequestBodyReader<I> entityRequestBodyReader;
        protected EntityResponseWriter<O> entityResponseWriter;
        protected EndpointParameterMapperRegistry registry;
        protected String name;
        protected Endpoint endpoint;
        protected ParamDef[] queryParameters = new ParamDef[0];
        protected HttpStatus successStatus = HttpStatus.OK;
        protected RestxLogLevel logLevel = RestxLogLevel.DEFAULT;
        protected PermissionFactory permissionFactory;
        protected MatchedEntityRoute<I, O> matchedEntityRoute;

        public Builder<I, O> entityRequestBodyReader(EntityRequestBodyReader<I> entityRequestBodyReader) {
            this.entityRequestBodyReader = entityRequestBodyReader;
            return this;
        }

        public Builder<I, O> entityResponseWriter(EntityResponseWriter<O> entityResponseWriter) {
            this.entityResponseWriter = entityResponseWriter;
            return this;
        }

        public Builder<I, O> name(String name) {
            this.name = name;
            return this;
        }

        public Builder<I, O> permissionFactory(PermissionFactory permissionFactory) {
            this.permissionFactory = permissionFactory;
            return this;
        }

        public Builder<I, O> endpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder<I, O> registry(EndpointParameterMapperRegistry registry) {
            this.registry = registry;
            return this;
        }

        public Builder<I, O> queryParameters(ParamDef[] queryParameters) {
            this.queryParameters = queryParameters;
            return this;
        }

        public Builder<I, O> successStatus(HttpStatus successStatus) {
            this.successStatus = successStatus;
            return this;
        }

        public Builder<I, O> logLevel(RestxLogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder<I, O> matchedEntityRoute(MatchedEntityRoute<I, O> matchedEntityRoute) {
            this.matchedEntityRoute = matchedEntityRoute;
            return this;
        }

        public StdEntityRoute<I, O> build() {
            Preconditions.checkNotNull(this.matchedEntityRoute, (Object)"you must provide a matchedEntityRoute");
            return new StdEntityRoute<I, O>(this.name, this.entityRequestBodyReader == null ? this.voidBodyReader() : this.entityRequestBodyReader, this.entityResponseWriter, this.endpoint, this.successStatus, this.logLevel, this.permissionFactory, this.registry, this.queryParameters){

                @Override
                protected Optional<O> doRoute(RestxRequest restxRequest, RestxResponse response, RestxRequestMatch match, I i) throws IOException {
                    return Builder.this.matchedEntityRoute.route(restxRequest, match, i);
                }
            };
        }

        private EntityRequestBodyReader<I> voidBodyReader() {
            return VoidContentTypeModule.VoidEntityRequestBodyReader.INSTANCE;
        }
    }
}

