/*
 * Decompiled with CFR 0.152.
 */
package restx.endpoint.mappers;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.List;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.common.AggregateType;
import restx.endpoint.EndpointParamDef;
import restx.endpoint.EndpointParameterKind;
import restx.endpoint.mappers.BaseTypeEndpointParameterMapper;
import restx.endpoint.mappers.EndpointParameterMapper;
import restx.factory.Component;

@Component
public class BaseTypeAggregateEndpointParameterMapper
implements EndpointParameterMapper {
    private BaseTypeEndpointParameterMapper baseTypeEndpointParameterMapper;

    public BaseTypeAggregateEndpointParameterMapper(BaseTypeEndpointParameterMapper baseTypeEndpointParameterMapper) {
        this.baseTypeEndpointParameterMapper = baseTypeEndpointParameterMapper;
    }

    @Override
    public <T> T mapRequest(EndpointParamDef endpointParamDef, RestxRequest request, RestxRequestMatch match, EndpointParameterKind parameterKind) {
        List<String> values = parameterKind.extractQueryParamStringedValuesFor(endpointParamDef, request, match);
        if (values == null) {
            return null;
        }
        Optional aggregateType = AggregateType.fromType((String)endpointParamDef.getRawType().getCanonicalName());
        if (!aggregateType.isPresent()) {
            throw new IllegalStateException("Called mapRequest() on base type aggregate whereas it is not considered as an aggregate !");
        }
        final Class aggregatedType = AggregateType.aggregatedTypeOf((Type)endpointParamDef.getType());
        ImmutableList convertedValues = FluentIterable.from(values).transform((Function)new Function<String, Object>(){

            public Object apply(String requestValue) {
                return BaseTypeAggregateEndpointParameterMapper.this.baseTypeEndpointParameterMapper.convertRequestParamValue((Optional<String>)Optional.fromNullable((Object)requestValue), aggregatedType, aggregatedType);
            }
        }).toList();
        return (T)((AggregateType)aggregateType.get()).createFrom((List)convertedValues, aggregatedType);
    }

    public boolean isBaseTypeAggregateParam(EndpointParamDef endpointParamDef) {
        return AggregateType.isAggregate((String)endpointParamDef.getRawType().getCanonicalName());
    }
}

