/*
 * Decompiled with CFR 0.152.
 */
package restx;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import restx.RestxHandler;
import restx.RestxHandlerMatch;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxRequestMatcher;
import restx.RestxResponse;
import restx.RestxRoute;
import restx.StdRestxRequestMatcher;
import restx.description.DescribableRoute;
import restx.description.OperationDescription;
import restx.description.ResourceDescription;
import restx.http.HttpStatus;

public abstract class StdRoute
implements RestxRoute,
DescribableRoute,
RestxHandler {
    private final String name;
    private final RestxRequestMatcher matcher;
    private final HttpStatus successStatus;

    public StdRoute(String name, RestxRequestMatcher matcher) {
        this(name, matcher, HttpStatus.OK);
    }

    public StdRoute(String name, RestxRequestMatcher matcher, HttpStatus successStatus) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.matcher = (RestxRequestMatcher)Preconditions.checkNotNull((Object)matcher);
        this.successStatus = (HttpStatus)((Object)Preconditions.checkNotNull((Object)((Object)successStatus)));
    }

    @Override
    public Optional<RestxHandlerMatch> match(RestxRequest req) {
        String path = req.getRestxPath();
        return RestxHandlerMatch.of(this.matcher.match(req.getHttpMethod(), path), this);
    }

    @Override
    public Collection<ResourceDescription> describe() {
        if (this.matcher instanceof StdRestxRequestMatcher) {
            ResourceDescription description = new ResourceDescription();
            StdRestxRequestMatcher stdRouteMatcher = (StdRestxRequestMatcher)this.matcher;
            description.path = stdRouteMatcher.getPathPattern();
            description.stdPath = stdRouteMatcher.getStdPathPattern();
            OperationDescription operation = new OperationDescription();
            operation.httpMethod = stdRouteMatcher.getMethod();
            operation.nickname = this.name.substring(this.name.lastIndexOf(35) + 1);
            operation.successStatus = this.getSuccessStatus().createDescriptor();
            this.describeOperation(operation);
            description.operations = Collections.singletonList(operation);
            return Collections.singleton(description);
        }
        return Collections.emptySet();
    }

    public HttpStatus getSuccessStatus() {
        return this.successStatus;
    }

    protected void describeOperation(OperationDescription operation) {
    }

    public RestxRequestMatcher getMatcher() {
        return this.matcher;
    }

    public String toString() {
        return this.matcher.toString() + " => " + this.name;
    }

    protected void notFound(RestxRequestMatch match, RestxResponse resp) throws IOException {
        resp.setStatus(HttpStatus.NOT_FOUND);
        resp.setContentType("text/plain");
        resp.getWriter().println("Route matched, but resource " + match.getPath() + " not found.");
        resp.getWriter().println("Matched route: " + this);
    }
}

